package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportTemplateDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportTemplate.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoReportTemplateDAOImpl implements IAutoReportTemplateDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportTemplate entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplate> getReportTemplateDataSet()
    {
        return new HibernateDataSet<ReportTemplate>(ReportTemplate.class, this, ReportTemplate.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoReportTemplateDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportTemplate object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportTemplate transientInstance) {
        logger.debug("persisting ReportTemplate instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportTemplate in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportTemplate instance) {
        logger.debug("attaching dirty ReportTemplate instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportTemplate instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportTemplate instance) {
        logger.debug("attaching clean ReportTemplate instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportTemplate instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportTemplate persistentInstance) {
        logger.debug("deleting ReportTemplate instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportTemplate instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportTemplate merge(ReportTemplate detachedInstance) {
        logger.debug("merging ReportTemplate instance");
        ReportTemplate result = (ReportTemplate) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportTemplate instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportTemplate findById( java.lang.Long id) {
        logger.debug("getting ReportTemplate instance with id: " + id);
        ReportTemplate instance = (ReportTemplate) getSession()
                .get(ReportTemplate.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplate> findAll() {

 		List<ReportTemplate> instances = new ArrayList<ReportTemplate>();
		logger.debug("getting all ReportTemplate instances");
        instances = getSession().createCriteria(ReportTemplate.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportTemplate>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportTemplate> findByExample(ReportTemplate instance) {
        logger.debug("finding ReportTemplate instance by example");
        List<ReportTemplate> results = (List<ReportTemplate>) getSession()
                .createCriteria(ReportTemplate.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplate> findByFieldParcial(ReportTemplate.Fields field, String value) {
        logger.debug("finding ReportTemplate instance by parcial value: "+field+" like "+value);
        List<ReportTemplate> results = (List<ReportTemplate>) getSession()
                .createCriteria(ReportTemplate.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByName(String name) {
        ReportTemplate instance = new ReportTemplate();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByDescription(String description) {
        ReportTemplate instance = new ReportTemplate();

        instance.setDescription(description);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the type attribute with the given value
	 *
	 * @param type to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByType(String type) {
        ReportTemplate instance = new ReportTemplate();

        instance.setType(type);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the enabled attribute with the given value
	 *
	 * @param enabled to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByEnabled(boolean enabled) {
        ReportTemplate instance = new ReportTemplate();

        instance.setEnabled(enabled);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the templateUrl attribute with the given value
	 *
	 * @param templateUrl to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByTemplateUrl(String templateUrl) {
        ReportTemplate instance = new ReportTemplate();

        instance.setTemplateUrl(templateUrl);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the templateFiles attribute with the given value
	 *
	 * @param templateFiles to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByTemplateFiles(Blob templateFiles) {
        ReportTemplate instance = new ReportTemplate();

        instance.setTemplateFiles(templateFiles);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the contextClassId attribute with the given value
	 *
	 * @param contextClassId to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByContextClassId(String contextClassId) {
        ReportTemplate instance = new ReportTemplate();

        instance.setContextClassId(contextClassId);

        return findByExample(instance);
    }

}

