package pt.digitalis.dif.dem.managers.impl.model.data;


import java.util.ArrayList;
import java.util.List;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;

/**
 * Serie
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class Serie extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** Serie attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** description column */
        public static final String DESCRIPTION = "description";
        /** unitName column */
        public static final String UNITNAME = "unitName";
        /** valueField column */
        public static final String VALUEFIELD = "valueField";
        /** type column */
        public static final String TYPE = "type";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("description");
            list.add("unitName");
            list.add("valueField");
            list.add("type");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * indicator relation.
         *
         * @return the indicator bean relations attributes.
         */
        public Indicator.Relations indicator()
        {
			Indicator c = new Indicator();
            return c.new Relations(this.buildPath("indicator"));
        }
        
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the DESCRIPTION path.
         *
         * @return the path
         */
        public String DESCRIPTION()
        {
            return buildPath(Fields.DESCRIPTION);
        }
		/**
         * the UNITNAME path.
         *
         * @return the path
         */
        public String UNITNAME()
        {
            return buildPath(Fields.UNITNAME);
        }
		/**
         * the VALUEFIELD path.
         *
         * @return the path
         */
        public String VALUEFIELD()
        {
            return buildPath(Fields.VALUEFIELD);
        }
		/**
         * the TYPE path.
         *
         * @return the path
         */
        public String TYPE()
        {
            return buildPath(Fields.TYPE);
        }
    }
	
	/** The dummy obj. */
    private static Serie dummyObj = new Serie();

	/**
     * Get Serie Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("indicator".equalsIgnoreCase(attributeName))
            return indicator;
        if ("description".equalsIgnoreCase(attributeName))
            return description;
        if ("unitName".equalsIgnoreCase(attributeName))
            return unitName;
        if ("valueField".equalsIgnoreCase(attributeName))
            return valueField;
        if ("type".equalsIgnoreCase(attributeName))
            return type;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("indicator".equalsIgnoreCase(attributeName))
            indicator = (Indicator)attributeValue;
        if ("description".equalsIgnoreCase(attributeName))
            description = (String)attributeValue;
        if ("unitName".equalsIgnoreCase(attributeName))
            unitName = (String)attributeValue;
        if ("valueField".equalsIgnoreCase(attributeName))
            valueField = (String)attributeValue;
        if ("type".equalsIgnoreCase(attributeName))
            type = (Character)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** indicator private attribute */
    private Indicator indicator;

    /** description private attribute */
    private String description;

    /** unitName private attribute */
    private String unitName;

    /** valueField private attribute */
    private String valueField;

    /** type private attribute */
    private Character type;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public Serie() {
    }

	/** 
	 * minimal constructor
	 *
     * @param indicator
     * @param type
    }
	 */
    public Serie(Indicator indicator, Character type) {
        this.indicator = indicator;
        this.type = type;
    }

    /**
     * full constructor
	 *
     * @param indicator
     * @param description
     * @param unitName
     * @param valueField
     * @param type
     */
    public Serie(Indicator indicator, String description, String unitName, String valueField, Character type) {
        this.indicator = indicator;
        this.description = description;
        this.unitName = unitName;
        this.valueField = valueField;
        this.type = type;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return Serie modified instance
     */
    public Serie setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * indicator getter method
     *
     * @return indicator method
     */
    public Indicator getIndicator() {
        return this.indicator;
    }
    
    /**       
     * indicator setter method
     *
     * @param indicator
     *
     * @return Serie modified instance
     */
    public Serie setIndicator(Indicator indicator) {
        this.indicator = indicator;
        
        return this;
    }
    /**       
     * description getter method
     *
     * @return description method
     */
    public String getDescription() {
        return this.description;
    }
    
    /**       
     * description setter method
     *
     * @param description
     *
     * @return Serie modified instance
     */
    public Serie setDescription(String description) {
        this.description = description;
        
        return this;
    }
    /**       
     * unitName getter method
     *
     * @return unitName method
     */
    public String getUnitName() {
        return this.unitName;
    }
    
    /**       
     * unitName setter method
     *
     * @param unitName
     *
     * @return Serie modified instance
     */
    public Serie setUnitName(String unitName) {
        this.unitName = unitName;
        
        return this;
    }
    /**       
     * valueField getter method
     *
     * @return valueField method
     */
    public String getValueField() {
        return this.valueField;
    }
    
    /**       
     * valueField setter method
     *
     * @param valueField
     *
     * @return Serie modified instance
     */
    public Serie setValueField(String valueField) {
        this.valueField = valueField;
        
        return this;
    }
    /**       
     * type getter method
     *
     * @return type method
     */
    public Character getType() {
        return this.type;
    }
    
    /**       
     * type setter method
     *
     * @param type
     *
     * @return Serie modified instance
     */
    public Serie setType(Character type) {
        this.type = type;
        
        return this;
    }

    /**
     * Creates a String representation of the Serie object
     *
     * @return the compiled String
     */
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("description").append("='").append(getDescription()).append("' ");			
        buffer.append("unitName").append("='").append(getUnitName()).append("' ");			
        buffer.append("valueField").append("='").append(getValueField()).append("' ");			
        buffer.append("type").append("='").append(getType()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the Serie object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(Serie other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("description".equalsIgnoreCase(attributeName))
        	this.description = attributeValue;

        if ("unitName".equalsIgnoreCase(attributeName))
        	this.unitName = attributeValue;

        if ("valueField".equalsIgnoreCase(attributeName))
        	this.valueField = attributeValue;

        if ("type".equalsIgnoreCase(attributeName))
            if (attributeValue != null && attributeValue.length() > 0)
                this.type = attributeValue.charAt(0);

    }


}
