package pt.digitalis.dif.dem.managers.impl.model;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.dif.dem.managers.impl.model.dao.IManagerDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Manager;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDashboardDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Dashboard;
import pt.digitalis.dif.dem.managers.impl.model.dao.IAreaDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Area;
import pt.digitalis.dif.dem.managers.impl.model.dao.IIndicatorDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.dem.managers.impl.model.dao.IDashboardIndicatorDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.DashboardIndicator;
import pt.digitalis.dif.dem.managers.impl.model.dao.IFilterDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Filter;
import pt.digitalis.dif.dem.managers.impl.model.dao.ISerieDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Serie;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public interface IDDMService {

	/**
	 * Obtains a new Manager DAO
	 *
	 * @return A new IManagerDAO
	 */
    public IManagerDAO getManagerDAO();

    /**
     * Obtains a new DataSet for the Manager entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Manager> getManagerDataSet();

	/**
	 * Obtains a new Dashboard DAO
	 *
	 * @return A new IDashboardDAO
	 */
    public IDashboardDAO getDashboardDAO();

    /**
     * Obtains a new DataSet for the Dashboard entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Dashboard> getDashboardDataSet();

	/**
	 * Obtains a new Area DAO
	 *
	 * @return A new IAreaDAO
	 */
    public IAreaDAO getAreaDAO();

    /**
     * Obtains a new DataSet for the Area entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Area> getAreaDataSet();

	/**
	 * Obtains a new Indicator DAO
	 *
	 * @return A new IIndicatorDAO
	 */
    public IIndicatorDAO getIndicatorDAO();

    /**
     * Obtains a new DataSet for the Indicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Indicator> getIndicatorDataSet();

	/**
	 * Obtains a new DashboardIndicator DAO
	 *
	 * @return A new IDashboardIndicatorDAO
	 */
    public IDashboardIndicatorDAO getDashboardIndicatorDAO();

    /**
     * Obtains a new DataSet for the DashboardIndicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DashboardIndicator> getDashboardIndicatorDataSet();

	/**
	 * Obtains a new Filter DAO
	 *
	 * @return A new IFilterDAO
	 */
    public IFilterDAO getFilterDAO();

    /**
     * Obtains a new DataSet for the Filter entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Filter> getFilterDataSet();

	/**
	 * Obtains a new Serie DAO
	 *
	 * @return A new ISerieDAO
	 */
    public ISerieDAO getSerieDAO();

    /**
     * Obtains a new DataSet for the Serie entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Serie> getSerieDataSet();


    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz);

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName);
}