package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class DataConsentUser.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DataConsentUser
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoDataConsentUserDAO extends IHibernateDAO<DataConsentUser> {

    /**
     * Obtains a new DataSet for the DataConsentUser entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentUser> getDataConsentUserDataSet();

	/**
	 * Persist a DataConsentUser object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DataConsentUser transientInstance);

	/**
	 * Updates a modified DataConsentUser in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DataConsentUser instance);

	/**
	 * Attach an unmodified DataConsentUser instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DataConsentUser instance);

	/**
	 * Removes a DataConsentUser instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DataConsentUser persistentInstance);

	/**
	 * Merge a DataConsentUser instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DataConsentUser merge(DataConsentUser detachedInstance);

	/**
	 * Finds a DataConsentUser instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DataConsentUser findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<DataConsentUser> findAll();


	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentUser> findByFieldParcial(DataConsentUser.Fields field, String value);

	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer than match the configId attribute with the given value
	 *
	 * @param configId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentUser> findByConfigId(String configId);

	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentUser> findByUserId(String userId);

	/**
	 * Gets a {@link List} of all DataConsentUser instances
	 * in the persistence layer than match the businessId attribute with the given value
	 *
	 * @param businessId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentUser> findByBusinessId(String businessId);
}
