package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateAreaSql;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportTemplateAreaSqlDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportTemplateAreaSql.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplateAreaSql
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoReportTemplateAreaSqlDAOImpl implements IAutoReportTemplateAreaSqlDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportTemplateAreaSql entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplateAreaSql> getReportTemplateAreaSqlDataSet()
    {
        return new HibernateDataSet<ReportTemplateAreaSql>(ReportTemplateAreaSql.class, this, ReportTemplateAreaSql.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoReportTemplateAreaSqlDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportTemplateAreaSql object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportTemplateAreaSql transientInstance) {
        logger.debug("persisting ReportTemplateAreaSql instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportTemplateAreaSql in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportTemplateAreaSql instance) {
        logger.debug("attaching dirty ReportTemplateAreaSql instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportTemplateAreaSql instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportTemplateAreaSql instance) {
        logger.debug("attaching clean ReportTemplateAreaSql instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportTemplateAreaSql instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportTemplateAreaSql persistentInstance) {
        logger.debug("deleting ReportTemplateAreaSql instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportTemplateAreaSql instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportTemplateAreaSql merge(ReportTemplateAreaSql detachedInstance) {
        logger.debug("merging ReportTemplateAreaSql instance");
        ReportTemplateAreaSql result = (ReportTemplateAreaSql) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportTemplateAreaSql instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportTemplateAreaSql findById( java.lang.Long id) {
        logger.debug("getting ReportTemplateAreaSql instance with id: " + id);
        ReportTemplateAreaSql instance = (ReportTemplateAreaSql) getSession()
                .get(ReportTemplateAreaSql.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportTemplateAreaSql instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplateAreaSql> findAll() {

 		List<ReportTemplateAreaSql> instances = new ArrayList<ReportTemplateAreaSql>();
		logger.debug("getting all ReportTemplateAreaSql instances");
        instances = getSession().createCriteria(ReportTemplateAreaSql.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportTemplateAreaSql>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportTemplateAreaSql instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportTemplateAreaSql> findByExample(ReportTemplateAreaSql instance) {
        logger.debug("finding ReportTemplateAreaSql instance by example");
        List<ReportTemplateAreaSql> results = (List<ReportTemplateAreaSql>) getSession()
                .createCriteria(ReportTemplateAreaSql.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportTemplateAreaSql instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportTemplateAreaSql> findByFieldParcial(ReportTemplateAreaSql.Fields field, String value) {
        logger.debug("finding ReportTemplateAreaSql instance by parcial value: "+field+" like "+value);
        List<ReportTemplateAreaSql> results = (List<ReportTemplateAreaSql>) getSession()
                .createCriteria(ReportTemplateAreaSql.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ReportTemplateAreaSql instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplateAreaSql> findByName(String name) {
        ReportTemplateAreaSql instance = new ReportTemplateAreaSql();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportTemplateAreaSql instances
	 * in the persistence layer than match the sql attribute with the given value
	 *
	 * @param sql to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplateAreaSql> findBySql(String sql) {
        ReportTemplateAreaSql instance = new ReportTemplateAreaSql();

        instance.setSql(sql);

        return findByExample(instance);
    }

}

