package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IAccessLogService;
import pt.digitalis.dif.dem.managers.impl.model.dao.IAccessLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.AccessLogDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.AccessLog;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class AccessLogServiceImpl implements IAccessLogService {

	/**
	 * Obtains a new AccessLog DAO
	 *
	 * @return A new IAccessLogDAO
	 */
    public IAccessLogDAO getAccessLogDAO() {
    	return new AccessLogDAOImpl();
    }

    /**
     * Obtains a new DataSet for the AccessLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<AccessLog> getAccessLogDataSet() {
        return new HibernateDataSet<AccessLog>(AccessLog.class, new AccessLogDAOImpl(),
                AccessLog.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == AccessLog.class)
            return getAccessLogDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(AccessLog.class.getSimpleName()))
            return getAccessLogDataSet();

        return null;
    }
}