DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM information_schema.COLUMNS c
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'REPORT_TEMPLATE_AREA' 
	AND COLUMN_NAME = 'CUSTOMIZABLE_PROFILES';

	IF TOTAL = 0 THEN
		ALTER TABLE `DIF`.`REPORT_TEMPLATE_AREA` ADD COLUMN `CUSTOMIZABLE_PROFILES` VARCHAR(4000) COMMENT 'the profiles that can customize the report instance area';
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

