-----------------------------------------------------------------------------------------------------------------------
--- TABLE JASPER_REPORT_CONFIG table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_CONFIG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.JASPER_REPORT_CONFIG( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  TEMPLATE_ID            NUMBER(10) NOT NULL, '||
      '  BUSINESS_ID            VARCHAR2(255), '||
      '  PARAMETERS_VALUES      VARCHAR2(4000)'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.JASPER_REPORT_CONFIG.ID IS 'ID';
COMMENT ON COLUMN dif.JASPER_REPORT_CONFIG.TEMPLATE_ID IS 'Jasper Report Template ID';
COMMENT ON COLUMN dif.JASPER_REPORT_CONFIG.BUSINESS_ID IS 'The business ID that somehow links this configuration to is business use';
COMMENT ON COLUMN dif.JASPER_REPORT_CONFIG.PARAMETERS_VALUES IS 'The parameter values in JSON format';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_CONFIG'
  AND    CONSTRAINT_NAME = 'JASPER_REPORT_CONFIG_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_CONFIG ADD CONSTRAINT JASPER_REPORT_CONFIG_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_JASPER_REPORT_CONFIG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_JASPER_REPORT_CONFIG MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_CONFIG'
  AND    INDEX_NAME = 'JASPER_REPORT_CONFIG_ID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.JASPER_REPORT_CONFIG_ID_IDX '||
                      'ON DIF.JASPER_REPORT_CONFIG (TEMPLATE_ID,BUSINESS_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_CONFIG'
  AND    CONSTRAINT_NAME = 'FK_JASPER_CONFIG_TEMPLATE';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_CONFIG ADD CONSTRAINT FK_JASPER_CONFIG_TEMPLATE FOREIGN KEY (TEMPLATE_ID) REFERENCES DIF.JASPER_REPORT_TEMPLATE (ID)';
  END IF;
END;
/

-----------------------------------------------------------------------------------------------------------------------
--- TABLE JASPER_REPORT_LOG table
-----------------------------------------------------------------------------------------------------------------------

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TABLES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE
      'CREATE TABLE DIF.JASPER_REPORT_LOG( '||
      '  ID                     NUMBER(10) NOT NULL, '||
      '  TEMPLATE_ID            NUMBER(10) NOT NULL, '||
      '  BUSINESS_ID            VARCHAR2(255), '||
      '  PARAMETERS_VALUES      VARCHAR2(4000),'||
      '  USER_ID                VARCHAR2(255),'||
      '  LOG_DATE               DATE DEFAULT SYSDATE NOT NULL,'||
      '  EXECUTION_TIME         NUMBER,'||
      '  DOCUMENT_ID            NUMBER'||
      ') ';
  END IF;
END;
/

COMMENT ON COLUMN dif.JASPER_REPORT_LOG.ID IS 'ID';
COMMENT ON COLUMN dif.JASPER_REPORT_LOG.TEMPLATE_ID IS 'Jasper Report Template ID';
COMMENT ON COLUMN dif.JASPER_REPORT_LOG.BUSINESS_ID IS 'The business ID that somehow links this configuration to is business use';
COMMENT ON COLUMN dif.JASPER_REPORT_LOG.PARAMETERS_VALUES IS 'The parameter values in JSON format';
COMMENT ON COLUMN dif.JASPER_REPORT_LOG.USER_ID IS 'The user ID';
COMMENT ON COLUMN dif.JASPER_REPORT_LOG.LOG_DATE IS 'The execution date';
COMMENT ON COLUMN dif.JASPER_REPORT_LOG.EXECUTION_TIME IS 'The execution elapsed time';
COMMENT ON COLUMN dif.JASPER_REPORT_LOG.DOCUMENT_ID IS 'The report generated';

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_LOG'
  AND    CONSTRAINT_NAME = 'JASPER_REPORT_LOG_PK';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_LOG ADD CONSTRAINT JASPER_REPORT_LOG_PK PRIMARY KEY (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_SEQUENCES
  WHERE  SEQUENCE_OWNER  = 'DIF'
  AND    SEQUENCE_NAME   = 'SEQ_ID_JASPER_REPORT_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE SEQUENCE DIF.SEQ_ID_JASPER_REPORT_LOG MINVALUE 1 MAXVALUE 999999999 START WITH 1 INCREMENT BY 1 CACHE 20 CYCLE';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_LOG'
  AND    INDEX_NAME = 'JASPER_REPORT_LOG_TEMPLATE_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.JASPER_REPORT_LOG_TEMPLATE_IDX '||
                      'ON DIF.JASPER_REPORT_LOG (TEMPLATE_ID,LOG_DATE) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_LOG'
  AND    INDEX_NAME = 'JASPER_REPORT_LOG_BID_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.JASPER_REPORT_LOG_BID_IDX '||
                      'ON DIF.JASPER_REPORT_LOG (BUSINESS_ID,LOG_DATE) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_INDEXES
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_LOG'
  AND    INDEX_NAME = 'JASPER_REPORT_LOG_DATE_IDX';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'CREATE INDEX DIF.JASPER_REPORT_LOG_DATE_IDX '||
                      'ON DIF.JASPER_REPORT_LOG (LOG_DATE, TEMPLATE_ID) '||
                      'TABLESPACE INDX PCTFREE 10 INITRANS 2 MAXTRANS 255 '||
                      'STORAGE (INITIAL 64K MINEXTENTS 1 MAXEXTENTS UNLIMITED)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_CONSTRAINTS
  WHERE  OWNER           = 'DIF'
  AND    TABLE_NAME      = 'JASPER_REPORT_LOG'
  AND    CONSTRAINT_NAME = 'FK_JASPER_CONFIG_LOG';

  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_LOG ADD CONSTRAINT FK_JASPER_CONFIG_LOG FOREIGN KEY (TEMPLATE_ID) REFERENCES DIF.JASPER_REPORT_TEMPLATE (ID)';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE'
    AND    COLUMN_NAME = 'LOG_EXECUTION';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE ADD LOG_EXECUTION NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.LOG_EXECUTION IS 'If the report executions should be logged.';

UPDATE DIF.JASPER_REPORT_TEMPLATE SET LOG_EXECUTION = 1 WHERE LOG_EXECUTION IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE'
  AND    COLUMN_NAME = 'LOG_EXECUTION'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE MODIFY LOG_EXECUTION NOT NULL';
  END IF;
END;
/

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO   TOTAL
    FROM   ALL_TAB_COLUMNS 
    WHERE  OWNER      = 'DIF'
    AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE'
    AND    COLUMN_NAME = 'LOG_FILE_RESULT';
  
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE   'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE ADD LOG_FILE_RESULT NUMBER(1)';
  END IF;
END;
/

COMMENT ON COLUMN dif.JASPER_REPORT_TEMPLATE.LOG_FILE_RESULT IS 'If the report file output should be logged.';

UPDATE DIF.JASPER_REPORT_TEMPLATE SET LOG_FILE_RESULT = 1 WHERE LOG_FILE_RESULT IS NULL;

DECLARE
  TOTAL NUMBER;
BEGIN
  SELECT COUNT(*)
  INTO   TOTAL
  FROM   ALL_TAB_COLUMNS 
  WHERE  OWNER      = 'DIF'
  AND    TABLE_NAME = 'JASPER_REPORT_TEMPLATE'
  AND    COLUMN_NAME = 'LOG_FILE_RESULT'
  AND    NULLABLE    = 'N';
      
  IF TOTAL = 0 THEN
    EXECUTE IMMEDIATE 'ALTER TABLE DIF.JASPER_REPORT_TEMPLATE MODIFY LOG_FILE_RESULT NOT NULL';
  END IF;
END;
/
