package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.DataConsentTrans;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoDataConsentTransDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class DataConsentTrans.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DataConsentTrans
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoDataConsentTransDAOImpl implements IAutoDataConsentTransDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the DataConsentTrans entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsentTrans> getDataConsentTransDataSet()
    {
        return new HibernateDataSet<DataConsentTrans>(DataConsentTrans.class, this, DataConsentTrans.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoDataConsentTransDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a DataConsentTrans object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DataConsentTrans transientInstance) {
        logger.debug("persisting DataConsentTrans instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified DataConsentTrans in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DataConsentTrans instance) {
        logger.debug("attaching dirty DataConsentTrans instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified DataConsentTrans instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DataConsentTrans instance) {
        logger.debug("attaching clean DataConsentTrans instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a DataConsentTrans instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DataConsentTrans persistentInstance) {
        logger.debug("deleting DataConsentTrans instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a DataConsentTrans instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DataConsentTrans merge(DataConsentTrans detachedInstance) {
        logger.debug("merging DataConsentTrans instance");
        DataConsentTrans result = (DataConsentTrans) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a DataConsentTrans instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DataConsentTrans findById( java.lang.Long id) {
        logger.debug("getting DataConsentTrans instance with id: " + id);
        DataConsentTrans instance = (DataConsentTrans) getSession()
                .get(DataConsentTrans.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsentTrans> findAll() {

 		List<DataConsentTrans> instances = new ArrayList<DataConsentTrans>();
		logger.debug("getting all DataConsentTrans instances");
        instances = getSession().createCriteria(DataConsentTrans.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<DataConsentTrans>) instances;
    }


	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<DataConsentTrans> findByExample(DataConsentTrans instance) {
        logger.debug("finding DataConsentTrans instance by example");
        List<DataConsentTrans> results = (List<DataConsentTrans>) getSession()
                .createCriteria(DataConsentTrans.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<DataConsentTrans> findByFieldParcial(DataConsentTrans.Fields field, String value) {
        logger.debug("finding DataConsentTrans instance by parcial value: "+field+" like "+value);
        List<DataConsentTrans> results = (List<DataConsentTrans>) getSession()
                .createCriteria(DataConsentTrans.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than match the languageId attribute with the given value
	 *
	 * @param languageId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findByLanguageId(String languageId) {
        DataConsentTrans instance = new DataConsentTrans();

        instance.setLanguageId(languageId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findByTitle(String title) {
        DataConsentTrans instance = new DataConsentTrans();

        instance.setTitle(title);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all DataConsentTrans instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsentTrans> findByDescription(String description) {
        DataConsentTrans instance = new DataConsentTrans();

        instance.setDescription(description);

        return findByExample(instance);
    }

}

