package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceArea;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportInstanceAreaDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportInstanceArea.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceArea
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoReportInstanceAreaDAOImpl implements IAutoReportInstanceAreaDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportInstanceArea entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceArea> getReportInstanceAreaDataSet()
    {
        return new HibernateDataSet<ReportInstanceArea>(ReportInstanceArea.class, this, ReportInstanceArea.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoReportInstanceAreaDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportInstanceArea object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportInstanceArea transientInstance) {
        logger.debug("persisting ReportInstanceArea instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportInstanceArea in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportInstanceArea instance) {
        logger.debug("attaching dirty ReportInstanceArea instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportInstanceArea instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportInstanceArea instance) {
        logger.debug("attaching clean ReportInstanceArea instance");
        getSession().lock(instance, LockMode.NONE);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportInstanceArea instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportInstanceArea persistentInstance) {
        logger.debug("deleting ReportInstanceArea instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportInstanceArea instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportInstanceArea merge(ReportInstanceArea detachedInstance) {
        logger.debug("merging ReportInstanceArea instance");
        ReportInstanceArea result = (ReportInstanceArea) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportInstanceArea instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportInstanceArea findById( java.lang.Long id) {
        logger.debug("getting ReportInstanceArea instance with id: " + id);
        ReportInstanceArea instance = (ReportInstanceArea) getSession()
                .get(ReportInstanceArea.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceArea> findAll() {

 		List<ReportInstanceArea> instances = new ArrayList<ReportInstanceArea>();
		logger.debug("getting all ReportInstanceArea instances");
        instances = getSession().createCriteria(ReportInstanceArea.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportInstanceArea>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportInstanceArea> findByExample(ReportInstanceArea instance) {
        logger.debug("finding ReportInstanceArea instance by example");
        List<ReportInstanceArea> results = (List<ReportInstanceArea>) getSession()
                .createCriteria(ReportInstanceArea.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceArea> findByFieldParcial(ReportInstanceArea.Fields field, String value) {
        logger.debug("finding ReportInstanceArea instance by parcial value: "+field+" like "+value);
        List<ReportInstanceArea> results = (List<ReportInstanceArea>) getSession()
                .createCriteria(ReportInstanceArea.class)
                .add( Expression.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByTitle(String title) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setTitle(title);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the showTitle attribute with the given value
	 *
	 * @param showTitle to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByShowTitle(boolean showTitle) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setShowTitle(showTitle);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the position attribute with the given value
	 *
	 * @param position to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByPosition(Long position) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setPosition(position);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the content attribute with the given value
	 *
	 * @param content to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByContent(String content) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setContent(content);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the private_ attribute with the given value
	 *
	 * @param private_ to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByPrivate_(boolean private_) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setPrivate_(private_);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the customizable attribute with the given value
	 *
	 * @param customizable to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByCustomizable(boolean customizable) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setCustomizable(customizable);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the mandatory attribute with the given value
	 *
	 * @param mandatory to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByMandatory(boolean mandatory) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setMandatory(mandatory);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the type attribute with the given value
	 *
	 * @param type to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByType(String type) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setType(type);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the language attribute with the given value
	 *
	 * @param language to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByLanguage(String language) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setLanguage(language);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceArea instances
	 * in the persistence layer than match the maxSize attribute with the given value
	 *
	 * @param maxSize to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceArea> findByMaxSize(Long maxSize) {
        ReportInstanceArea instance = new ReportInstanceArea();

        instance.setMaxSize(maxSize);

        return findByExample(instance);
    }

}

