/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers.impl;

import pt.digitalis.dif.dem.managers.impl.model.ITemplateRepositoryService;
import pt.digitalis.dif.dem.managers.impl.model.data.TemplateRepository;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.Query;
import pt.digitalis.utils.common.StringUtils;

/**
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created 14/07/2016
 */
public class TemplateManagerDBImpl extends TemplateManagerStaticImpl {

    /**
     * @see pt.digitalis.dif.dem.managers.impl.TemplateManagerStaticImpl#allowTemplateCustomization()
     */
    @Override
    public boolean allowTemplateCustomization()
    {
        return true;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.TemplateManagerStaticImpl#doGetTemplateContent(java.lang.String,
     *      java.lang.String)
     */
    @Override
    protected StringBuffer doGetTemplateContent(String resource, String language) throws Exception
    {
        StringBuffer result = null;

        ITemplateRepositoryService templateRepositoryService = DIFIoCRegistry.getRegistry()
                .getImplementation(ITemplateRepositoryService.class);

        Query<TemplateRepository> query = templateRepositoryService.getTemplateRepositoryDataSet().query();
        query.equals(TemplateRepository.Fields.NAME, resource);
        query.equals(TemplateRepository.Fields.LANGUAGE, language);

        TemplateRepository template = query.singleValue();

        if (template != null)
        {
            result = new StringBuffer(template.getContent());
        }
        else
        {
            /* No template found! let's try to find it using the static implementation (aka files on disk) */
            result = super.doGetTemplateContent(resource, language);
        }

        return result;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.TemplateManagerStaticImpl#saveTemplateContent(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    @Override
    public void saveTemplateContent(String resource, String language, String newContent) throws Exception
    {
        this.invalidateCache(resource);

        ITemplateRepositoryService templateRepositoryService = DIFIoCRegistry.getRegistry()
                .getImplementation(ITemplateRepositoryService.class);
        IDataSet<TemplateRepository> dataSet = templateRepositoryService.getTemplateRepositoryDataSet();

        Query<TemplateRepository> query = dataSet.query();
        query.equals(TemplateRepository.Fields.NAME, resource);
        query.equals(TemplateRepository.Fields.LANGUAGE, language);

        TemplateRepository template = query.singleValue();
        newContent = StringUtils.nvl(newContent, " ");

        if (template != null)
        {
            template.setContent(newContent);
            template = dataSet.update(template);
        }
        else
        {
            // No template found! let's insert it
            template = new TemplateRepository();
            template.setName(resource);
            template.setLanguage(language);
            template.setContent(newContent);
            template = dataSet.insert(template);
        }
    }
}
