package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.DataConsent;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class DataConsent.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.DataConsent
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoDataConsentDAO extends IHibernateDAO<DataConsent> {

    /**
     * Obtains a new DataSet for the DataConsent entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<DataConsent> getDataConsentDataSet();

	/**
	 * Persist a DataConsent object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(DataConsent transientInstance);

	/**
	 * Updates a modified DataConsent in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(DataConsent instance);

	/**
	 * Attach an unmodified DataConsent instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(DataConsent instance);

	/**
	 * Removes a DataConsent instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(DataConsent persistentInstance);

	/**
	 * Merge a DataConsent instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public DataConsent merge(DataConsent detachedInstance);

	/**
	 * Finds a DataConsent instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public DataConsent findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findAll();


	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByFieldParcial(DataConsent.Fields field, String value);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the configId attribute with the given value
	 *
	 * @param configId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByConfigId(String configId);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the businessId attribute with the given value
	 *
	 * @param businessId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByBusinessId(String businessId);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByTitle(String title);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByDescription(String description);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the templateDocumentId attribute with the given value
	 *
	 * @param templateDocumentId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByTemplateDocumentId(Long templateDocumentId);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the profileId attribute with the given value
	 *
	 * @param profileId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByProfileId(String profileId);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the isMustUploadProof attribute with the given value
	 *
	 * @param isMustUploadProof to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByIsMustUploadProof(boolean isMustUploadProof);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the isMustConfirmBymail attribute with the given value
	 *
	 * @param isMustConfirmBymail to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByIsMustConfirmBymail(boolean isMustConfirmBymail);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the isMandatory attribute with the given value
	 *
	 * @param isMandatory to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByIsMandatory(boolean isMandatory);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the isProtected attribute with the given value
	 *
	 * @param isProtected to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByIsProtected(boolean isProtected);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the isEnabled attribute with the given value
	 *
	 * @param isEnabled to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByIsEnabled(boolean isEnabled);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the stageId attribute with the given value
	 *
	 * @param stageId to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByStageId(String stageId);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the isGlobal attribute with the given value
	 *
	 * @param isGlobal to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByIsGlobal(boolean isGlobal);

	/**
	 * Gets a {@link List} of all DataConsent instances
	 * in the persistence layer than match the isAnsweredWhenDisabled attribute with the given value
	 *
	 * @param isAnsweredWhenDisabled to match
	 * @return the {@link List} of instances
	 */
    public List<DataConsent> findByIsAnsweredWhenDisabled(boolean isAnsweredWhenDisabled);
}
