/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.ecommerce;

import java.util.Map;

import pt.digitalis.dif.dem.managers.impl.model.data.EcommercePayments;

/**
 * The Interface IECommerce.
 * 
 * @param <T>
 *            provider payment response type
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created May 9, 2012
 */
public interface IECommerce<T> {

    /**
     * Creates the provider response.
     * 
     * @param params
     *            the parameters
     * @param success
     *            the success
     * @return the t
     */
    public T createProviderResponse(Map<String, Object> params, boolean success);

    /**
     * Gets the identifier.
     * 
     * @return the identifier
     */
    public String getIdentifier();

    /**
     * Gets the short identifier.
     * 
     * @return the short identifier
     */
    public String getShortIdentifier();

    /**
     * Init's the web payment.
     * 
     * @param payment
     *            the payment
     * @param partialBusinessId
     *            the partial BusinessId id (i.e. RU:XXXX-12345). Generated by {@link AbstractECommerceBusinessImpl}
     * @return the payment response
     * @throws PaymentException
     *             the payment exception
     */
    public EcommercePayments initWebPayment(PaymentRequest payment, String partialBusinessId) throws PaymentException;

    /**
     * Init's the web payment.
     * 
     * @param payment
     *            the payment
     * @param partialBusinessId
     *            the partial BusinessId id (i.e. RU:XXXX-12345). Generated by {@link AbstractECommerceBusinessImpl}
     *            .encode
     * @param configurationId
     *            the configuration id
     * @return the payment response
     * @throws PaymentException
     *             the payment exception
     */
    public EcommercePayments initWebPayment(PaymentRequest payment, String partialBusinessId, String configurationId)
            throws PaymentException;

    /**
     * Checks is the ECommerce implementation is active
     * 
     * @param configurationId
     *            the configuraction id
     * @return the short identifier
     */
    public boolean isActive(String configurationId);

    /**
     * Process business payment.
     * 
     * @param ePaymentRecord
     *            the e payment record
     * @return the ecommerce payments
     * @throws PaymentException
     *             the payment exception
     */
    public abstract EcommercePayments processBusinessPayment(EcommercePayments ePaymentRecord) throws PaymentException;

    /**
     * Process web payment.
     * 
     * @param businessID
     *            the business ID to process
     * @return the payment record
     * @throws PaymentException
     *             the payment exception
     */
    public EcommercePayments processWebPayment(String businessID) throws PaymentException;

    /**
     * Process web payment.
     * 
     * @param businessID
     *            the business ID to process
     * @param securityToken
     *            the payment security token
     * @param providerResponse
     *            provider payment response type
     * @return the payment record
     * @throws PaymentException
     *             the payment exception
     */
    public EcommercePayments processWebPayment(String businessID, String securityToken, T providerResponse)
            throws PaymentException;
}
