DELIMITER $$
CREATE TABLE IF NOT EXISTS `ACCESS_LOG` (
  `ID` MEDIUMINT(9) NOT NULL AUTO_INCREMENT COMMENT 'ID column',
  `APPLICATION_ID` VARCHAR(100) NOT NULL COMMENT 'Aplication Identifier',

  `SERVICE_ID` VARCHAR(100) NOT NULL COMMENT 'Service Identifier',
  `STAGE_ID` VARCHAR(100) NOT NULL COMMENT 'Stage Identifier',
  `EVENT_ID` VARCHAR(100) COMMENT 'Event identifier (form submit, ajax event, document request...)',
  `REQUEST_TYPE` VARCHAR(1) NOT NULL COMMENT 'Request type ([S]ubmit, [A]jax, [D]ocument, [P]age)',
  `USER_ID` VARCHAR(200) COMMENT 'User Identifier',
  `ACCESS_DATE` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Request date/time',
  `execution_time` MEDIUMINT(10) NOT NULL COMMENT 'Time the request took to execute (view not included)',
  `CLIENT_IP` VARCHAR(40) NOT NULL COMMENT 'The client IP that made the request',
  `REQUEST_DUMP` LONGTEXT COMMENT 'The DIF request (when trace logging is enabled)',
  `ERROR_REPORT` LONGTEXT COMMENT 'The error description if unsuccessful',
  PRIMARY KEY (`ID`),
  KEY `AL_SERVICE_IDX` (`APPLICATION_ID`,`SERVICE_ID`, `ACCESS_DATE`),
  KEY `AL_STAGE_IDX` (`STAGE_ID`, `ACCESS_DATE`),
  KEY `AL_DATE_IDX` (`ACCESS_DATE`),
  KEY `AL_USER_IDX` (`USER_ID`, `ACCESS_DATE`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8$$
