package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Serie;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoSerieDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Serie.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Serie
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoSerieDAOImpl implements IAutoSerieDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Serie entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Serie> getSerieDataSet()
    {
        return new HibernateDataSet<Serie>(Serie.class, this, Serie.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoSerieDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Serie object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Serie transientInstance) {
        logger.debug("persisting Serie instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Serie in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Serie instance) {
        logger.debug("attaching dirty Serie instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Serie instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Serie instance) {
        logger.debug("attaching clean Serie instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Serie instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Serie persistentInstance) {
        logger.debug("deleting Serie instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Serie instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Serie merge(Serie detachedInstance) {
        logger.debug("merging Serie instance");
        Serie result = (Serie) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Serie instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Serie findById( java.lang.Long id) {
        logger.debug("getting Serie instance with id: " + id);
        Serie instance = (Serie) getSession()
                .get(Serie.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Serie> findAll() {

 		List<Serie> instances = new ArrayList<Serie>();
		logger.debug("getting all Serie instances");
        instances = getSession().createCriteria(Serie.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Serie>) instances;
    }


	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Serie> findByExample(Serie instance) {
        logger.debug("finding Serie instance by example");
        List<Serie> results = (List<Serie>) getSession()
                .createCriteria(Serie.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Serie> findByFieldParcial(Serie.Fields field, String value) {
        logger.debug("finding Serie instance by parcial value: "+field+" like "+value);
        List<Serie> results = (List<Serie>) getSession()
                .createCriteria(Serie.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<Serie> findByDescription(String description) {
        Serie instance = new Serie();

        instance.setDescription(description);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer than match the unitName attribute with the given value
	 *
	 * @param unitName to match
	 * @return the {@link List} of instances
	 */
    public List<Serie> findByUnitName(String unitName) {
        Serie instance = new Serie();

        instance.setUnitName(unitName);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer than match the valueField attribute with the given value
	 *
	 * @param valueField to match
	 * @return the {@link List} of instances
	 */
    public List<Serie> findByValueField(String valueField) {
        Serie instance = new Serie();

        instance.setValueField(valueField);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Serie instances
	 * in the persistence layer than match the type attribute with the given value
	 *
	 * @param type to match
	 * @return the {@link List} of instances
	 */
    public List<Serie> findByType(Character type) {
        Serie instance = new Serie();

        instance.setType(type);

        return findByExample(instance);
    }

}

