/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoSerieDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Serie;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoSerieDAOImpl
implements IAutoSerieDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Serie> getSerieDataSet() {
        return new HibernateDataSet(Serie.class, (IHibernateDAO)this, Serie.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Serie transientInstance) {
        this.logger.debug((Object)"persisting Serie instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Serie instance) {
        this.logger.debug((Object)"attaching dirty Serie instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Serie instance) {
        this.logger.debug((Object)"attaching clean Serie instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Serie persistentInstance) {
        this.logger.debug((Object)"deleting Serie instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Serie merge(Serie detachedInstance) {
        this.logger.debug((Object)"merging Serie instance");
        Serie result = (Serie)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Serie findById(Long id) {
        this.logger.debug((Object)("getting Serie instance with id: " + id));
        Serie instance = (Serie)this.getSession().get(Serie.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Serie> findAll() {
        List<Serie> instances = new ArrayList();
        this.logger.debug((Object)"getting all Serie instances");
        instances = this.getSession().createCriteria(Serie.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Serie> findByExample(Serie instance) {
        this.logger.debug((Object)"finding Serie instance by example");
        List results = this.getSession().createCriteria(Serie.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Serie> findByFieldParcial(Serie.Fields field, String value) {
        this.logger.debug((Object)("finding Serie instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Serie.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Serie> findByDescription(String description) {
        Serie instance = new Serie();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<Serie> findByUnitName(String unitName) {
        Serie instance = new Serie();
        instance.setUnitName(unitName);
        return this.findByExample(instance);
    }

    @Override
    public List<Serie> findByValueField(String valueField) {
        Serie instance = new Serie();
        instance.setValueField(valueField);
        return this.findByExample(instance);
    }

    @Override
    public List<Serie> findByType(Character type) {
        Serie instance = new Serie();
        instance.setType(type);
        return this.findByExample(instance);
    }
}

