package pt.digitalis.dif.dem.managers.impl.model.dao.impl;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.dao.ICustomMessagesDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.AutoCustomMessagesDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages;

/**
 * Home object for domain model class CustomMessages. Generated on Jan 3, 2014 DIF build process for the Model layer
 * 
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class CustomMessagesDAOImpl extends AutoCustomMessagesDAOImpl implements ICustomMessagesDAO {

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.ICustomMessagesDAO#findAllWithEntityAndMessageIDs(java.lang.String,
     *      java.lang.String)
     */
    @SuppressWarnings("unchecked")
    public List<CustomMessages> findAllWithEntityAndMessageIDs(String entityID, String messageID)
    {
        // Init result
        List<CustomMessages> result = null;

        // Do query
        result = getSession().createQuery("from CustomMessages customMessages where " + CustomMessages.Fields.ENTITYID
                + " like '" + entityID + "' and " + CustomMessages.Fields.MESSAGEID + " like '" + messageID + "'")
                .list();

        // Return result
        return result;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.ICustomMessagesDAO#findAllWithEntityName(java.lang.String)
     */
    @SuppressWarnings("unchecked")
    public List<CustomMessages> findAllWithEntityName(String entityName)
    {

        // Init result
        List<CustomMessages> customMessages = null;

        // Do query (get all the rows whose entityID contains the entity name)
        customMessages = getSession().createQuery("from CustomMessages customMessages where "
                + CustomMessages.Fields.ENTITYID + " like '%" + entityName + "%'").list();

        // Return result
        return customMessages;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.ICustomMessagesDAO#findByEntityAndMessageIDAndLanguage(java.lang.String,
     *      java.lang.String, java.lang.String)
     */
    @SuppressWarnings("unchecked")
    public CustomMessages findByEntityAndMessageIDAndLanguage(String entityID, String messageID, String language)
    {
        // Init result
        CustomMessages result = null;

        List<CustomMessages> list = getSession().createQuery("from CustomMessages customMessages where "
                + CustomMessages.Fields.ENTITYID + " like '" + entityID + "' and " + CustomMessages.Fields.MESSAGEID
                + " like '" + messageID + "'" + " and " + CustomMessages.Fields.LANGUAGE + " = '" + language + "'")
                .list();

        // Do query
        if (list.size() > 0)
            result = list.get(0);

        // Return result
        return result;
    }
}