package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.sql.Blob;
import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class ReportTemplate.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoReportTemplateDAO extends IHibernateDAO<ReportTemplate> {

    /**
     * Obtains a new DataSet for the ReportTemplate entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportTemplate> getReportTemplateDataSet();

	/**
	 * Persist a ReportTemplate object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportTemplate transientInstance);

	/**
	 * Updates a modified ReportTemplate in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportTemplate instance);

	/**
	 * Attach an unmodified ReportTemplate instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportTemplate instance);

	/**
	 * Removes a ReportTemplate instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportTemplate persistentInstance);

	/**
	 * Merge a ReportTemplate instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportTemplate merge(ReportTemplate detachedInstance);

	/**
	 * Finds a ReportTemplate instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportTemplate findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findAll();


	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByFieldParcial(ReportTemplate.Fields field, String value);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByName(String name);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByDescription(String description);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the type attribute with the given value
	 *
	 * @param type to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByType(String type);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the enabled attribute with the given value
	 *
	 * @param enabled to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByEnabled(boolean enabled);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the templateUrl attribute with the given value
	 *
	 * @param templateUrl to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByTemplateUrl(String templateUrl);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the templateFiles attribute with the given value
	 *
	 * @param templateFiles to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByTemplateFiles(Blob templateFiles);

	/**
	 * Gets a {@link List} of all ReportTemplate instances
	 * in the persistence layer than match the contextClassId attribute with the given value
	 *
	 * @param contextClassId to match
	 * @return the {@link List} of instances
	 */
    public List<ReportTemplate> findByContextClassId(String contextClassId);
}
