-----------------------------------------------------------------------------------------------------------------------
--- TABLE JASPER_REPORT_TEMPLATE table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.JASPER_REPORT_TEMPLATE
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  CONFIG_ID              VARCHAR(255) NOT NULL  COMMENT 'Configuration ID (each application can have a diferent set of templates)',
  BUSINESS_ID            VARCHAR(255)           COMMENT 'Busines ID',
  TITLE                  VARCHAR(500) NOT NULL  COMMENT 'The title',
  DESCRIPTION            LONGTEXT NOT NULL      COMMENT 'A full description',
  TYPE                   TINYINT(2) 			COMMENT 'The template type 1=TemplatePathOnServer,2=TemplateUploadedFiles',
  TEMPLATE_PATH          VARCHAR(1000) NOT NULL COMMENT 'The jasper report template path',
  IS_ENABLED             TINYINT(1) NOT NULL    COMMENT 'Is enabled',
  PRIMARY KEY (`ID`), 
  INDEX `JASPER_REPT_TEMP_CONF_ID_IDX` (`CONFIG_ID`,`TITLE`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- JASPER_REPORT_TEMPLATE_FILE table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.JASPER_REPORT_TEMPLATE_FILE
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  TEMPLATE_ID            INT NOT NULL COMMENT 'The template the file belongs to',
  FILE_NAME              VARCHAR(1500) NOT NULL COMMENT 'The file name',
  FILE_TYPE              VARCHAR(50) NOT NULL COMMENT 'The file type (mime type)',
  FILE_SIZE              INT NOT NULL COMMENT 'The file size',
  DOCUMENT_ID            INT NOT NULL COMMENT 'The document in the documento repository ID',
  PRIMARY KEY (`ID`), 
  KEY `JASPER_REPT_TEMP_FILE_PK` (`ID`),
  CONSTRAINT `FK_JASPER_TEMP_FILE_TEMPLATE` FOREIGN KEY (`TEMPLATE_ID`) REFERENCES `JASPER_REPORT_TEMPLATE` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-----------------------------------------------------------------------------------------------------------------------
--- JASPER_REPORT_TEMPLATE_LOV table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.JASPER_REPORT_TEMPLATE_PARAM
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  TEMPLATE_ID            INT NOT NULL          COMMENT 'The template the param definition belongs to',
  PARAMETER_ID           VARCHAR(100) NOT NULL COMMENT 'The parameter ID',
  PARAMETER_NAME         VARCHAR(300) NOT NULL COMMENT 'The parameter name',
  PARAMETER_OPTIONS_TYPE TINYINT(2) NOT NULL   COMMENT 'The parameter options type (0=No options;1=Static list;2=SQL',
  PARAMETER_OPTIONS_LIST LONGTEXT              COMMENT 'The parameter options list (key value list)',
  PARAMETER_OPTIONS_SQL  LONGTEXT              COMMENT 'The parameter options SQL',
  IS_ENABLED             TINYINT(1) NOT NULL   COMMENT 'Is enabled',
  PRIMARY KEY (`ID`), 
  KEY `JASPER_REPT_TEMP_PARAM_PK` (`ID`),
  CONSTRAINT `FK_JASPER_TEMP_PARAM_TEMPLATE` FOREIGN KEY (`TEMPLATE_ID`) REFERENCES `JASPER_REPORT_TEMPLATE` (`ID`) ON DELETE CASCADE ON UPDATE NO ACTION
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$

-- -----------------------------------------------------
-- Create Constraint 'fk_jasper_template_file' 
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS createConstraint;
$$
CREATE PROCEDURE createConstraint()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM   INFORMATION_SCHEMA.TABLE_CONSTRAINTS
	where table_schema = 'dif'
	and table_name = 'jasper_report_template'
	and constraint_name = 'fk_jasper_template_file';

	IF TOTAL = 0 THEN
		ALTER TABLE `dif`.`jasper_report_template`
			ADD CONSTRAINT `fk_jasper_template_file`
			  FOREIGN KEY (`template_file_id`)
			  REFERENCES `dif`.`jasper_report_template_file` (`id`)
			  ON DELETE NO ACTION
			  ON UPDATE NO ACTION;
    END IF;
END
$$
CALL createConstraint();
$$
DROP PROCEDURE IF EXISTS createConstraint;
$$
