package pt.digitalis.dif.dem.managers.impl.model.dao;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoCustomMessagesDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.CustomMessages;

/**
 * Home object for domain model class CustomMessages. Generated on Jan 3, 2014 DIF build process for the Model layer
 * 
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface ICustomMessagesDAO extends IAutoCustomMessagesDAO {

    /**
     * Returns the list of custom messages with the given entity and message ID.
     * 
     * @param entityID
     *            the entity ID
     * @param messageID
     *            the message ID
     * @return the list of custom messages with the given entity and message ID
     */
    public List<CustomMessages> findAllWithEntityAndMessageIDs(String entityID, String messageID);

    /**
     * Returns the list of custom messages of the entity with the given name.
     * 
     * @param entityName
     *            the entity name to search for
     * @return the list of custom messages for the entity with the given name
     */
    public List<CustomMessages> findAllWithEntityName(String entityName);

    /**
     * Returns the custom message for the given entity, message ID and language.
     * 
     * @param entityID
     *            the entity ID
     * @param messageID
     *            the message ID
     * @param language
     *            the language
     * @return the list of custom messages with the given entity and message ID
     */
    public CustomMessages findByEntityAndMessageIDAndLanguage(String entityID, String messageID, String language);
}