package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Area;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Area.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Area
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoAreaDAO extends IHibernateDAO<Area> {

    /**
     * Obtains a new DataSet for the Area entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Area> getAreaDataSet();

	/**
	 * Persist a Area object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Area transientInstance);

	/**
	 * Updates a modified Area in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Area instance);

	/**
	 * Attach an unmodified Area instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Area instance);

	/**
	 * Removes a Area instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Area persistentInstance);

	/**
	 * Merge a Area instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Area merge(Area detachedInstance);

	/**
	 * Finds a Area instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Area findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Area> findAll();


	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByFieldParcial(Area.Fields field, String value);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the uniqueId attribute with the given value
	 *
	 * @param uniqueId to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByUniqueId(String uniqueId);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByTitle(String title);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the databaseUrl attribute with the given value
	 *
	 * @param databaseUrl to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByDatabaseUrl(String databaseUrl);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the databaseUser attribute with the given value
	 *
	 * @param databaseUser to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByDatabaseUser(String databaseUser);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the databasePass attribute with the given value
	 *
	 * @param databasePass to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByDatabasePass(String databasePass);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the restrictGroups attribute with the given value
	 *
	 * @param restrictGroups to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByRestrictGroups(String restrictGroups);

	/**
	 * Gets a {@link List} of all Area instances
	 * in the persistence layer than match the restrictProfiles attribute with the given value
	 *
	 * @param restrictProfiles to match
	 * @return the {@link List} of instances
	 */
    public List<Area> findByRestrictProfiles(String restrictProfiles);
}
