DELIMITER $$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'REPORT_TEMPLATE_AREA_SQL' 
  AND COLUMN_NAME = 'SQL_DATA_SOURCE_ID'
  AND IS_NULLABLE = 'NO';
	
  IF TOTAL > 0 THEN
	ALTER TABLE `DIF`.`REPORT_TEMPLATE_AREA_SQL` CHANGE COLUMN `SQL_DATA_SOURCE_ID` `SQL_DATA_SOURCE_ID` INT(10) COMMENT 'the data source ID';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'REPORT_INSTANCE_AREA_SQL' 
  AND COLUMN_NAME = 'SQL_DATA_SOURCE_ID'
  AND IS_NULLABLE = 'NO';
	
  IF TOTAL > 0 THEN
		ALTER TABLE `DIF`.`REPORT_INSTANCE_AREA_SQL` CHANGE COLUMN `SQL_DATA_SOURCE_ID` `SQL_DATA_SOURCE_ID` INT(10) COMMENT 'the data source ID';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

