package pt.digitalis.dif.dem.managers.impl.model.dao.impl;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl.AutoAclDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Acl;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.Filter;
import pt.digitalis.dif.model.dataset.FilterType;
import pt.digitalis.dif.model.dataset.Query;

/**
 * Home object for domain model class Acl. Generated on May 10, 2012 DIF build process for the Model layer
 * 
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public class AclDAOImpl extends AutoAclDAOImpl implements IAclDAO {

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#deleteAllGroupAccess(java.lang.String)
     */
    public boolean deleteAllGroupAccess(String groupID)
    {

        List<Acl> entries = findByGroupId(groupID);

        for (Acl entry: entries)
            delete(entry);

        return (entries.size() > 0 ? true : false);
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#deleteAllUserAccess(java.lang.String)
     */
    public boolean deleteAllUserAccess(String userID)
    {

        List<Acl> entries = findByUserId(userID);

        for (Acl entry: entries)
            delete(entry);

        return (entries.size() > 0 ? true : false);
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#deleteGroupAccess(java.lang.String, java.lang.String,
     *      java.lang.String)
     */
    public boolean deleteGroupAccess(String groupID, String entityType, String entityID) throws DataSetException
    {
        Query<Acl> query = this.getAclDataSet().query();
        query = query.addFilter(new Filter(Acl.Fields.GROUPID.toString(), FilterType.EQUALS, groupID.toString()));
        query = query.addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.EQUALS, entityType.toString()));
        query = query.addFilter(
                new Filter(Acl.Fields.ENTITYID.toString(), FilterType.EQUALS_INSENSITIVE, entityID.toString()));

        List<Acl> entries = query.asList();

        for (Acl entry: entries)
        {
            if (!"S".equals(entry.getIsDefault()))
                delete(entry);
            else
            {
                entry.setIsEnabled("N");
                getSession().save(entry);
            }
        }

        return (entries.size() > 0 ? true : false);
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#deletePublicAccess(java.lang.String, java.lang.String)
     */
    public boolean deletePublicAccess(String entityType, String entityID)
    {

        // Delete the entries that are not default
        String hqlDelete = "delete " + Acl.class.getCanonicalName() + " acl where acl." + Acl.Fields.PUBLICACCESS
                + " = 'S' and lower(acl." + Acl.Fields.ENTITYID + ") = :entityID and acl." + Acl.Fields.ENTITYTYPE
                + " = :entityType and acl." + Acl.Fields.ISDEFAULT + " = 'N'";

        org.hibernate.Query query = getSession().createQuery(hqlDelete);
        query.setString("entityID", entityID);
        query.setString("entityType", entityType);

        int deletedEntities = query.executeUpdate();

        // Disable default entries
        Acl publicAccess = new Acl();
        publicAccess.setPublicAccess("S");
        publicAccess.setIsDefault("S");
        publicAccess.setEntityType(entityType);
        publicAccess.setEntityId(entityID);

        List<Acl> entries = findByExample(publicAccess);

        int updatedEntities = 0;

        for (Acl entry: entries)
        {
            entry.setIsEnabled("N");
            getSession().save(entry);
            ++updatedEntities;
        }

        return ((deletedEntities > 0 || updatedEntities > 0) ? true : false);
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#deleteUserAccess(java.lang.String, java.lang.String,
     *      java.lang.String)
     */
    public boolean deleteUserAccess(String userID, String entityType, String entityID) throws DataSetException
    {

        Query<Acl> query = this.getAclDataSet().query();
        query = query.addFilter(new Filter(Acl.Fields.USERID.toString(), FilterType.EQUALS, userID.toString()));
        query = query.addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.EQUALS, entityType.toString()));
        query = query.addFilter(
                new Filter(Acl.Fields.ENTITYID.toString(), FilterType.EQUALS_INSENSITIVE, entityID.toString()));

        List<Acl> entries = query.asList();

        for (Acl entry: entries)
        {
            if (!"S".equals(entry.getIsDefault()))
                delete(entry);
            else
            {
                entry.setIsEnabled("N");
                getSession().save(entry);
            }
        }

        return (entries.size() > 0 ? true : false);
    }

    /**
     * Get a list of {@link Acl}
     * 
     * @param acl
     *            the {@link Acl}
     * @return List of {@link Acl}
     * @throws DataSetException
     */
    public List<Acl> getAcl(Acl acl) throws DataSetException
    {
        Query<Acl> query = this.getAclDataSet().query();
        if (acl.getUserId() != null)
            query = query.addFilter(new Filter(Acl.Fields.USERID.toString(), FilterType.EQUALS, acl.getUserId()));
        if (acl.getEntityType() != null)
            query = query
                    .addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.EQUALS, acl.getEntityType()));
        if (acl.getEntityId() != null)
            query = query.addFilter(
                    new Filter(Acl.Fields.ENTITYID.toString(), FilterType.EQUALS_INSENSITIVE, acl.getEntityId()));
        if (acl.getGroupId() != null)
            query = query.addFilter(new Filter(Acl.Fields.GROUPID.toString(), FilterType.EQUALS, acl.getGroupId()));
        if (acl.getIsDefault() != null)
            query = query.addFilter(new Filter(Acl.Fields.ISDEFAULT.toString(), FilterType.EQUALS, acl.getIsDefault()));
        if (acl.getIsEnabled() != null)
            query = query.addFilter(new Filter(Acl.Fields.ISENABLED.toString(), FilterType.EQUALS, acl.getIsEnabled()));
        if (acl.getPublicAccess() != null)
            query = query.addFilter(
                    new Filter(Acl.Fields.PUBLICACCESS.toString(), FilterType.EQUALS, acl.getPublicAccess()));

        return query.asList();
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#getAclByGroup(java.lang.String, java.lang.String,
     *      java.lang.String)
     */
    public Acl getAclByGroup(String groupId, String entityType, String entityID) throws DataSetException
    {
        Query<Acl> query = this.getAclDataSet().query();
        query = query.addFilter(new Filter(Acl.Fields.GROUPID.toString(), FilterType.EQUALS, groupId.toString()));

        if (entityType != null)
            query = query
                    .addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.EQUALS, entityType.toString()));
        else
            query = query.addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.IS_NULL));

        if (entityID != null)
            query = query.addFilter(
                    new Filter(Acl.Fields.ENTITYID.toString(), FilterType.EQUALS_INSENSITIVE, entityID.toString()));
        else
            query = query.addFilter(new Filter(Acl.Fields.ENTITYID.toString(), FilterType.IS_NULL));

        // query = query.addFilter(new Filter(Acl.Fields.ISDEFAULT.toString(), FilterType.EQUALS, isDefault ? "S" :
        // "N"));

        return query.singleValue();
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#getAclByPublic(java.lang.String, java.lang.String)
     */
    public Acl getAclByPublic(String entityType, String entityID) throws DataSetException
    {
        Query<Acl> query = this.getAclDataSet().query();
        query = query.addFilter(new Filter(Acl.Fields.PUBLICACCESS.toString(), FilterType.EQUALS, "S"));

        if (entityType != null)
            query = query
                    .addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.EQUALS, entityType.toString()));
        else
            query = query.addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.IS_NULL));

        if (entityID != null)
            query = query.addFilter(
                    new Filter(Acl.Fields.ENTITYID.toString(), FilterType.EQUALS_INSENSITIVE, entityID.toString()));
        else
            query = query.addFilter(new Filter(Acl.Fields.ENTITYID.toString(), FilterType.IS_NULL));

        // query = query.addFilter(new Filter(Acl.Fields.ISDEFAULT.toString(), FilterType.EQUALS, isDefault ? "S" :
        // "N"));

        return query.singleValue();
    }

    /**
     * @see pt.digitalis.dif.dem.managers.impl.model.dao.IAclDAO#getAclByUser(java.lang.String, java.lang.String,
     *      java.lang.String)
     */
    public Acl getAclByUser(String userId, String entityType, String entityID) throws DataSetException
    {
        Query<Acl> query = this.getAclDataSet().query();
        query = query.addFilter(new Filter(Acl.Fields.USERID.toString(), FilterType.EQUALS, userId.toString()));

        if (entityType != null)
            query = query
                    .addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.EQUALS, entityType.toString()));
        else
            query = query.addFilter(new Filter(Acl.Fields.ENTITYTYPE.toString(), FilterType.IS_NULL));

        if (entityID != null)
            query = query.addFilter(
                    new Filter(Acl.Fields.ENTITYID.toString(), FilterType.EQUALS_INSENSITIVE, entityID.toString()));
        else
            query = query.addFilter(new Filter(Acl.Fields.ENTITYID.toString(), FilterType.IS_NULL));

        // query = query.addFilter(new Filter(Acl.Fields.ISDEFAULT.toString(), FilterType.EQUALS, isDefault ? "S" :
        // "N"));

        return query.singleValue();
    }
}