/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoPersistentActionDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoPersistentActionDAOImpl
implements IAutoPersistentActionDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<PersistentAction> getPersistentActionDataSet() {
        return new HibernateDataSet(PersistentAction.class, (IHibernateDAO)this, PersistentAction.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(PersistentAction transientInstance) {
        this.logger.debug((Object)"persisting PersistentAction instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(PersistentAction instance) {
        this.logger.debug((Object)"attaching dirty PersistentAction instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(PersistentAction instance) {
        this.logger.debug((Object)"attaching clean PersistentAction instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(PersistentAction persistentInstance) {
        this.logger.debug((Object)"deleting PersistentAction instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public PersistentAction merge(PersistentAction detachedInstance) {
        this.logger.debug((Object)"merging PersistentAction instance");
        PersistentAction result = (PersistentAction)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public PersistentAction findById(Long id) {
        this.logger.debug((Object)("getting PersistentAction instance with id: " + id));
        PersistentAction instance = (PersistentAction)this.getSession().get(PersistentAction.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<PersistentAction> findAll() {
        List<PersistentAction> instances = new ArrayList();
        this.logger.debug((Object)"getting all PersistentAction instances");
        instances = this.getSession().createCriteria(PersistentAction.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<PersistentAction> findByExample(PersistentAction instance) {
        this.logger.debug((Object)"finding PersistentAction instance by example");
        List results = this.getSession().createCriteria(PersistentAction.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<PersistentAction> findByFieldParcial(PersistentAction.Fields field, String value) {
        this.logger.debug((Object)("finding PersistentAction instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(PersistentAction.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<PersistentAction> findByObjectAction(Blob objectAction) {
        PersistentAction instance = new PersistentAction();
        instance.setObjectAction(objectAction);
        return this.findByExample(instance);
    }

    @Override
    public List<PersistentAction> findByPoolName(String poolName) {
        PersistentAction instance = new PersistentAction();
        instance.setPoolName(poolName);
        return this.findByExample(instance);
    }

    @Override
    public List<PersistentAction> findByActionId(Long actionId) {
        PersistentAction instance = new PersistentAction();
        instance.setActionId(actionId);
        return this.findByExample(instance);
    }
}

