DELIMITER $$

USE `DIF` ;
$$

DROP PROCEDURE IF EXISTS createIndex;
$$

CREATE PROCEDURE createIndex()
BEGIN
	DECLARE TOTAL INT;

	SELECT COUNT(*)
	INTO TOTAL
	FROM INFORMATION_SCHEMA.STATISTICS
	WHERE TABLE_CATALOG = 'def'
	AND TABLE_SCHEMA = 'DIF'
	AND TABLE_NAME = 'AUDIT_LOG_DETAIL'
	AND INDEX_NAME = 'AUDIT_LOG_DETAIL_LOG_IDX';

	IF TOTAL = 0 THEN
        ALTER TABLE `DIF`.`AUDIT_LOG_DETAIL` ADD INDEX `AUDIT_LOG_DETAIL_LOG_IDX` (`audit_log_id`, `id`);
    END IF;
END
$$

CALL createIndex();
$$

DROP PROCEDURE IF EXISTS createIndex;
$$