DELIMITER $$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
	DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
	FROM information_schema.COLUMNS 
	WHERE TABLE_SCHEMA = 'DIF' 
	AND TABLE_NAME = 'REPORT_TEMPLATE' 
	AND COLUMN_NAME = 'TEMPLATE_URL'
	AND IS_NULLABLE = 'NO';
	
	IF TOTAL > 0 THEN
		ALTER TABLE `DIF`.`REPORT_TEMPLATE` CHANGE COLUMN `TEMPLATE_URL` `TEMPLATE_URL` VARCHAR(2000) COMMENT 'the report template URL';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$
