package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoServerDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Server.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Server
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoServerDAOImpl implements IAutoServerDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Server entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Server> getServerDataSet()
    {
        return new HibernateDataSet<Server>(Server.class, this, Server.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoServerDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Server object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Server transientInstance) {
        logger.debug("persisting Server instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Server in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Server instance) {
        logger.debug("attaching dirty Server instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Server instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Server instance) {
        logger.debug("attaching clean Server instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Server instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Server persistentInstance) {
        logger.debug("deleting Server instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Server instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Server merge(Server detachedInstance) {
        logger.debug("merging Server instance");
        Server result = (Server) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Server instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Server findById( java.lang.Long id) {
        logger.debug("getting Server instance with id: " + id);
        Server instance = (Server) getSession()
                .get(Server.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Server> findAll() {

 		List<Server> instances = new ArrayList<Server>();
		logger.debug("getting all Server instances");
        instances = getSession().createCriteria(Server.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Server>) instances;
    }


	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Server> findByExample(Server instance) {
        logger.debug("finding Server instance by example");
        List<Server> results = (List<Server>) getSession()
                .createCriteria(Server.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Server> findByFieldParcial(Server.Fields field, String value) {
        logger.debug("finding Server instance by parcial value: "+field+" like "+value);
        List<Server> results = (List<Server>) getSession()
                .createCriteria(Server.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByName(String name) {
        Server instance = new Server();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the machineServerUid attribute with the given value
	 *
	 * @param machineServerUid to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByMachineServerUid(String machineServerUid) {
        Server instance = new Server();

        instance.setMachineServerUid(machineServerUid);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the ipAddress attribute with the given value
	 *
	 * @param ipAddress to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByIpAddress(String ipAddress) {
        Server instance = new Server();

        instance.setIpAddress(ipAddress);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the contextRoot attribute with the given value
	 *
	 * @param contextRoot to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByContextRoot(String contextRoot) {
        Server instance = new Server();

        instance.setContextRoot(contextRoot);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the port attribute with the given value
	 *
	 * @param port to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByPort(String port) {
        Server instance = new Server();

        instance.setPort(port);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the endpointBaseUrl attribute with the given value
	 *
	 * @param endpointBaseUrl to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByEndpointBaseUrl(String endpointBaseUrl) {
        Server instance = new Server();

        instance.setEndpointBaseUrl(endpointBaseUrl);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the bootTime attribute with the given value
	 *
	 * @param bootTime to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByBootTime(Timestamp bootTime) {
        Server instance = new Server();

        instance.setBootTime(bootTime);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the lastSync attribute with the given value
	 *
	 * @param lastSync to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByLastSync(Timestamp lastSync) {
        Server instance = new Server();

        instance.setLastSync(lastSync);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the active attribute with the given value
	 *
	 * @param active to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByActive(boolean active) {
        Server instance = new Server();

        instance.setActive(active);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Server instances
	 * in the persistence layer than match the missing attribute with the given value
	 *
	 * @param missing to match
	 * @return the {@link List} of instances
	 */
    public List<Server> findByMissing(boolean missing) {
        Server instance = new Server();

        instance.setMissing(missing);

        return findByExample(instance);
    }

}

