package pt.digitalis.dif.dem.managers.impl.model;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.dif.dem.managers.impl.model.dao.IServerDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.dem.managers.impl.model.dao.IServerActivityLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog;
import pt.digitalis.dif.dem.managers.impl.model.dao.IServerMessageDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public interface IServersService {

	/**
	 * Obtains a new Server DAO
	 *
	 * @return A new IServerDAO
	 */
    public IServerDAO getServerDAO();

    /**
     * Obtains a new DataSet for the Server entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Server> getServerDataSet();

	/**
	 * Obtains a new ServerActivityLog DAO
	 *
	 * @return A new IServerActivityLogDAO
	 */
    public IServerActivityLogDAO getServerActivityLogDAO();

    /**
     * Obtains a new DataSet for the ServerActivityLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ServerActivityLog> getServerActivityLogDataSet();

	/**
	 * Obtains a new ServerMessage DAO
	 *
	 * @return A new IServerMessageDAO
	 */
    public IServerMessageDAO getServerMessageDAO();

    /**
     * Obtains a new DataSet for the ServerMessage entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ServerMessage> getServerMessageDataSet();


    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz);

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName);
}