package pt.digitalis.dif.dem.managers.impl.model.dao;

import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoPersistentActionDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.PersistentAction;

/**
 * Home object for domain model class PersistentAction. Generated on Nov 25, 2009 DIF build process for the Model layer
 * 
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IPersistentActionDAO extends IAutoPersistentActionDAO {

    /**
     * Delete Action by :
     * 
     * @param actionId
     *            the action internal id.
     * @param poolName
     *            the action pool name.
     */
    public void deleteActionByInternalIdAndName(Long actionId, String poolName);

    /**
     * Get Actions by:
     * 
     * @param actionId
     *            the action internal id.
     * @param poolName
     *            the action pool name.
     * @return the <code>PersistentAction</code>.
     */
    public PersistentAction getAction(Long actionId, String poolName);

    /**
     * Get the List of actions by parameter:
     * 
     * @param poolName
     *            the pool name for the action.
     * @return List of <code>PersistentAction</code>.
     */
    public List<PersistentAction> getActionsByPool(String poolName);
}