package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.Indicator;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class Indicator.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Indicator
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoIndicatorDAO extends IHibernateDAO<Indicator> {

    /**
     * Obtains a new DataSet for the Indicator entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Indicator> getIndicatorDataSet();

	/**
	 * Persist a Indicator object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Indicator transientInstance);

	/**
	 * Updates a modified Indicator in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Indicator instance);

	/**
	 * Attach an unmodified Indicator instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Indicator instance);

	/**
	 * Removes a Indicator instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Indicator persistentInstance);

	/**
	 * Merge a Indicator instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Indicator merge(Indicator detachedInstance);

	/**
	 * Finds a Indicator instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Indicator findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findAll();


	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByFieldParcial(Indicator.Fields field, String value);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the uniqueId attribute with the given value
	 *
	 * @param uniqueId to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByUniqueId(String uniqueId);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the definitionType attribute with the given value
	 *
	 * @param definitionType to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByDefinitionType(Character definitionType);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByTitle(String title);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByDescription(String description);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the descriptionTitle attribute with the given value
	 *
	 * @param descriptionTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByDescriptionTitle(String descriptionTitle);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the groupTitle attribute with the given value
	 *
	 * @param groupTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByGroupTitle(String groupTitle);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the autoRefreshInt attribute with the given value
	 *
	 * @param autoRefreshInt to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByAutoRefreshInt(Long autoRefreshInt);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the limitTopRecords attribute with the given value
	 *
	 * @param limitTopRecords to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByLimitTopRecords(Long limitTopRecords);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the maxValue attribute with the given value
	 *
	 * @param maxValue to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByMaxValue(Long maxValue);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the unitSuffix attribute with the given value
	 *
	 * @param unitSuffix to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByUnitSuffix(String unitSuffix);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the axisXTitle attribute with the given value
	 *
	 * @param axisXTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByAxisXTitle(String axisXTitle);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the axisYTitle attribute with the given value
	 *
	 * @param axisYTitle to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByAxisYTitle(String axisYTitle);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the totalField attribute with the given value
	 *
	 * @param totalField to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByTotalField(boolean totalField);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the hideMarkers attribute with the given value
	 *
	 * @param hideMarkers to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByHideMarkers(boolean hideMarkers);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the legend attribute with the given value
	 *
	 * @param legend to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByLegend(boolean legend);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the timeKeys attribute with the given value
	 *
	 * @param timeKeys to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByTimeKeys(boolean timeKeys);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the useMinutes attribute with the given value
	 *
	 * @param useMinutes to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByUseMinutes(boolean useMinutes);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the querySql attribute with the given value
	 *
	 * @param querySql to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByQuerySql(String querySql);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the viewsToRefresh attribute with the given value
	 *
	 * @param viewsToRefresh to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByViewsToRefresh(String viewsToRefresh);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the restrictGroups attribute with the given value
	 *
	 * @param restrictGroups to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByRestrictGroups(String restrictGroups);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the restrictProfiles attribute with the given value
	 *
	 * @param restrictProfiles to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByRestrictProfiles(String restrictProfiles);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the isVisible attribute with the given value
	 *
	 * @param isVisible to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByIsVisible(boolean isVisible);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the chartMode attribute with the given value
	 *
	 * @param chartMode to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByChartMode(boolean chartMode);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the groupPosition attribute with the given value
	 *
	 * @param groupPosition to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByGroupPosition(Long groupPosition);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the position attribute with the given value
	 *
	 * @param position to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByPosition(Long position);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the gridColumns attribute with the given value
	 *
	 * @param gridColumns to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByGridColumns(String gridColumns);

	/**
	 * Gets a {@link List} of all Indicator instances
	 * in the persistence layer than match the visibleFor attribute with the given value
	 *
	 * @param visibleFor to match
	 * @return the {@link List} of instances
	 */
    public List<Indicator> findByVisibleFor(String visibleFor);
}
