package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.sql.Timestamp;
import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class ServerActivityLog.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoServerActivityLogDAO extends IHibernateDAO<ServerActivityLog> {

    /**
     * Obtains a new DataSet for the ServerActivityLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ServerActivityLog> getServerActivityLogDataSet();

	/**
	 * Persist a ServerActivityLog object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ServerActivityLog transientInstance);

	/**
	 * Updates a modified ServerActivityLog in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ServerActivityLog instance);

	/**
	 * Attach an unmodified ServerActivityLog instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ServerActivityLog instance);

	/**
	 * Removes a ServerActivityLog instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ServerActivityLog persistentInstance);

	/**
	 * Merge a ServerActivityLog instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ServerActivityLog merge(ServerActivityLog detachedInstance);

	/**
	 * Finds a ServerActivityLog instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ServerActivityLog findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<ServerActivityLog> findAll();


	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<ServerActivityLog> findByFieldParcial(ServerActivityLog.Fields field, String value);

	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer than match the bootTime attribute with the given value
	 *
	 * @param bootTime to match
	 * @return the {@link List} of instances
	 */
    public List<ServerActivityLog> findByBootTime(Timestamp bootTime);

	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer than match the lastSync attribute with the given value
	 *
	 * @param lastSync to match
	 * @return the {@link List} of instances
	 */
    public List<ServerActivityLog> findByLastSync(Timestamp lastSync);
}
