package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoServerActivityLogDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ServerActivityLog.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoServerActivityLogDAOImpl implements IAutoServerActivityLogDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ServerActivityLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ServerActivityLog> getServerActivityLogDataSet()
    {
        return new HibernateDataSet<ServerActivityLog>(ServerActivityLog.class, this, ServerActivityLog.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoServerActivityLogDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ServerActivityLog object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ServerActivityLog transientInstance) {
        logger.debug("persisting ServerActivityLog instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ServerActivityLog in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ServerActivityLog instance) {
        logger.debug("attaching dirty ServerActivityLog instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ServerActivityLog instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ServerActivityLog instance) {
        logger.debug("attaching clean ServerActivityLog instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ServerActivityLog instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ServerActivityLog persistentInstance) {
        logger.debug("deleting ServerActivityLog instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ServerActivityLog instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ServerActivityLog merge(ServerActivityLog detachedInstance) {
        logger.debug("merging ServerActivityLog instance");
        ServerActivityLog result = (ServerActivityLog) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ServerActivityLog instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ServerActivityLog findById( java.lang.Long id) {
        logger.debug("getting ServerActivityLog instance with id: " + id);
        ServerActivityLog instance = (ServerActivityLog) getSession()
                .get(ServerActivityLog.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ServerActivityLog> findAll() {

 		List<ServerActivityLog> instances = new ArrayList<ServerActivityLog>();
		logger.debug("getting all ServerActivityLog instances");
        instances = getSession().createCriteria(ServerActivityLog.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ServerActivityLog>) instances;
    }


	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ServerActivityLog> findByExample(ServerActivityLog instance) {
        logger.debug("finding ServerActivityLog instance by example");
        List<ServerActivityLog> results = (List<ServerActivityLog>) getSession()
                .createCriteria(ServerActivityLog.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ServerActivityLog> findByFieldParcial(ServerActivityLog.Fields field, String value) {
        logger.debug("finding ServerActivityLog instance by parcial value: "+field+" like "+value);
        List<ServerActivityLog> results = (List<ServerActivityLog>) getSession()
                .createCriteria(ServerActivityLog.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer than match the bootTime attribute with the given value
	 *
	 * @param bootTime to match
	 * @return the {@link List} of instances
	 */
    public List<ServerActivityLog> findByBootTime(Timestamp bootTime) {
        ServerActivityLog instance = new ServerActivityLog();

        instance.setBootTime(bootTime);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ServerActivityLog instances
	 * in the persistence layer than match the lastSync attribute with the given value
	 *
	 * @param lastSync to match
	 * @return the {@link List} of instances
	 */
    public List<ServerActivityLog> findByLastSync(Timestamp lastSync) {
        ServerActivityLog instance = new ServerActivityLog();

        instance.setLastSync(lastSync);

        return findByExample(instance);
    }

}

