package pt.digitalis.dif.dem.managers.impl.model.data;


import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.utils.common.DateUtils;

/**
 * JasperReportLog
 * Generated on ORM Generator
 * DIF build process for the Model layer
 *
 */
@SuppressWarnings("serial")
public class JasperReportLog extends AbstractBeanRelationsAttributes implements java.io.Serializable {

    /** JasperReportLog attributes enumeration */
    public static class Fields {
        /** id column */
        public static final String ID = "id";
        /** businessId column */
        public static final String BUSINESSID = "businessId";
        /** parametersValues column */
        public static final String PARAMETERSVALUES = "parametersValues";
        /** userId column */
        public static final String USERID = "userId";
        /** logDate column */
        public static final String LOGDATE = "logDate";
        /** executionTime column */
        public static final String EXECUTIONTIME = "executionTime";
        /** documentId column */
        public static final String DOCUMENTID = "documentId";

	    /**
          * List of existing fields
	     *
	     * @return list of field names
	     */
        public static List<String> values() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("id");
            list.add("businessId");
            list.add("parametersValues");
            list.add("userId");
            list.add("logDate");
            list.add("executionTime");
            list.add("documentId");

            return list;
        }
    }

	/**
 	 * The Class Relations.
 	 */
	 public class Relations extends AbstractBeanRelationsAttributes.AbstractRelations {

        /**
         * Instantiates a new relations.
         *
         * @param currentPath
         *            the current path
         */
        public Relations(String currentPath)
        {
            super(currentPath);
        }
        /**
         * jasperReportTemplate relation.
         *
         * @return the jasperReportTemplate bean relations attributes.
         */
        public JasperReportTemplate.Relations jasperReportTemplate()
        {
			JasperReportTemplate c = new JasperReportTemplate();
            return c.new Relations(this.buildPath("jasperReportTemplate"));
        }
        
		/**
         * the ID path.
         *
         * @return the path
         */
        public String ID()
        {
            return buildPath(Fields.ID);
        }
		/**
         * the BUSINESSID path.
         *
         * @return the path
         */
        public String BUSINESSID()
        {
            return buildPath(Fields.BUSINESSID);
        }
		/**
         * the PARAMETERSVALUES path.
         *
         * @return the path
         */
        public String PARAMETERSVALUES()
        {
            return buildPath(Fields.PARAMETERSVALUES);
        }
		/**
         * the USERID path.
         *
         * @return the path
         */
        public String USERID()
        {
            return buildPath(Fields.USERID);
        }
		/**
         * the LOGDATE path.
         *
         * @return the path
         */
        public String LOGDATE()
        {
            return buildPath(Fields.LOGDATE);
        }
		/**
         * the EXECUTIONTIME path.
         *
         * @return the path
         */
        public String EXECUTIONTIME()
        {
            return buildPath(Fields.EXECUTIONTIME);
        }
		/**
         * the DOCUMENTID path.
         *
         * @return the path
         */
        public String DOCUMENTID()
        {
            return buildPath(Fields.DOCUMENTID);
        }
    }
	
	/** The dummy obj. */
    private static JasperReportLog dummyObj = new JasperReportLog();

	/**
     * Get JasperReportLog Relations .
     *
     * @return the relations
     */
    public static Relations FK()
    {
        return dummyObj.new Relations(null);
    }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeNoGraphNavigation(java.lang.String)
     */
    @Override
    protected Object getAttributeNoGraphNavigation(String attributeName) {

        if ("id".equalsIgnoreCase(attributeName))
            return id;
        if ("jasperReportTemplate".equalsIgnoreCase(attributeName))
            return jasperReportTemplate;
        if ("businessId".equalsIgnoreCase(attributeName))
            return businessId;
        if ("parametersValues".equalsIgnoreCase(attributeName))
            return parametersValues;
        if ("userId".equalsIgnoreCase(attributeName))
            return userId;
        if ("logDate".equalsIgnoreCase(attributeName))
            return logDate;
        if ("executionTime".equalsIgnoreCase(attributeName))
            return executionTime;
        if ("documentId".equalsIgnoreCase(attributeName))
            return documentId;

        return null;
    }

    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttribute(java.lang.String, java.lang.Object)
     */
    @SuppressWarnings("all")
    public void setAttribute(String attributeName, Object attributeValue) {

        if ("id".equalsIgnoreCase(attributeName))
            id = (Long)attributeValue;
        if ("jasperReportTemplate".equalsIgnoreCase(attributeName))
            jasperReportTemplate = (JasperReportTemplate)attributeValue;
        if ("businessId".equalsIgnoreCase(attributeName))
            businessId = (String)attributeValue;
        if ("parametersValues".equalsIgnoreCase(attributeName))
            parametersValues = (String)attributeValue;
        if ("userId".equalsIgnoreCase(attributeName))
            userId = (String)attributeValue;
        if ("logDate".equalsIgnoreCase(attributeName))
            logDate = (Date)attributeValue;
        if ("executionTime".equalsIgnoreCase(attributeName))
            executionTime = (Long)attributeValue;
        if ("documentId".equalsIgnoreCase(attributeName))
            documentId = (Long)attributeValue;
    }

    // Fields

    /** id private attribute */
    private Long id;

    /** jasperReportTemplate private attribute */
    private JasperReportTemplate jasperReportTemplate;

    /** businessId private attribute */
    private String businessId;

    /** parametersValues private attribute */
    private String parametersValues;

    /** userId private attribute */
    private String userId;

    /** logDate private attribute */
    private Date logDate;

    /** executionTime private attribute */
    private Long executionTime;

    /** documentId private attribute */
    private Long documentId;

    /** The pojo's primary key field list names */
    private static List<String> pkFieldList;

    /**
     * Get the table fields that compose the PK
     *
     * @return the PK field list
     */
     public synchronized static List<String> getPKFieldList()
     {
         if (pkFieldList == null)
         {
             pkFieldList = new ArrayList<String>();
             pkFieldList.add("id");
         }

         return pkFieldList;
     }

    /**
     * Get the table fields that compose the PK as a comma separated field name list
     *
     * @return the PK field list as a string
     */
     public static String getPKFieldListAsString()
     {
         StringBuffer buffer = new StringBuffer();

         for (int i = 0; i < getPKFieldList().size(); i++)
         {
             if (i != 0)
                 buffer.append(",");

             buffer.append(getPKFieldList().get(i));
         }

         return buffer.toString();
     }

    /**
     * @see pt.digitalis.dif.model.utils.AbstractBeanAttributes#getAttributeAsString(java.lang.String)
     */
     @Override
     public String getAttributeAsString(String attributeName)
     {

        Object value = getAttribute(attributeName);

        if (value == null)
            return "";
        else {
            if ("logDate".equalsIgnoreCase(attributeName))
        	    return DateUtils.simpleDateToString((Date)value);
            return value.toString().trim();
        }
     }

    // Constructors

    /**
     * default constructor
     */
    public JasperReportLog() {
    }

	/** 
	 * minimal constructor
	 *
     * @param jasperReportTemplate
     * @param logDate
    }
	 */
    public JasperReportLog(JasperReportTemplate jasperReportTemplate, Date logDate) {
        this.jasperReportTemplate = jasperReportTemplate;
        this.logDate = logDate;
    }

    /**
     * full constructor
	 *
     * @param jasperReportTemplate
     * @param businessId
     * @param parametersValues
     * @param userId
     * @param logDate
     * @param executionTime
     * @param documentId
     */
    public JasperReportLog(JasperReportTemplate jasperReportTemplate, String businessId, String parametersValues, String userId, Date logDate, Long executionTime, Long documentId) {
        this.jasperReportTemplate = jasperReportTemplate;
        this.businessId = businessId;
        this.parametersValues = parametersValues;
        this.userId = userId;
        this.logDate = logDate;
        this.executionTime = executionTime;
        this.documentId = documentId;
    }

    // Property accessors
    
    /**       
     * id getter method
     *
     * @return id method
     */
    public Long getId() {
        return this.id;
    }
    
    /**       
     * id setter method
     *
     * @param id
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setId(Long id) {
        this.id = id;
        
        return this;
    }
    /**       
     * jasperReportTemplate getter method
     *
     * @return jasperReportTemplate method
     */
    public JasperReportTemplate getJasperReportTemplate() {
        return this.jasperReportTemplate;
    }
    
    /**       
     * jasperReportTemplate setter method
     *
     * @param jasperReportTemplate
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setJasperReportTemplate(JasperReportTemplate jasperReportTemplate) {
        this.jasperReportTemplate = jasperReportTemplate;
        
        return this;
    }
    /**       
     * businessId getter method
     *
     * @return businessId method
     */
    public String getBusinessId() {
        return this.businessId;
    }
    
    /**       
     * businessId setter method
     *
     * @param businessId
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setBusinessId(String businessId) {
        this.businessId = businessId;
        
        return this;
    }
    /**       
     * parametersValues getter method
     *
     * @return parametersValues method
     */
    public String getParametersValues() {
        return this.parametersValues;
    }
    
    /**       
     * parametersValues setter method
     *
     * @param parametersValues
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setParametersValues(String parametersValues) {
        this.parametersValues = parametersValues;
        
        return this;
    }
    /**       
     * userId getter method
     *
     * @return userId method
     */
    public String getUserId() {
        return this.userId;
    }
    
    /**       
     * userId setter method
     *
     * @param userId
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setUserId(String userId) {
        this.userId = userId;
        
        return this;
    }
    /**       
     * logDate getter method
     *
     * @return logDate method
     */
    public Date getLogDate() {
        return this.logDate;
    }
    
    /**       
     * logDate setter method
     *
     * @param logDate
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setLogDate(Date logDate) {
        this.logDate = logDate;
        
        return this;
    }
    /**       
     * executionTime getter method
     *
     * @return executionTime method
     */
    public Long getExecutionTime() {
        return this.executionTime;
    }
    
    /**       
     * executionTime setter method
     *
     * @param executionTime
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
        
        return this;
    }
    /**       
     * documentId getter method
     *
     * @return documentId method
     */
    public Long getDocumentId() {
        return this.documentId;
    }
    
    /**       
     * documentId setter method
     *
     * @param documentId
     *
     * @return JasperReportLog modified instance
     */
    public JasperReportLog setDocumentId(Long documentId) {
        this.documentId = documentId;
        
        return this;
    }

    /**
     * Creates a String representation of the JasperReportLog object
     *
     * @return the compiled String
     */
    @Override
    public String toString() {
	    StringBuffer buffer = new StringBuffer();

        buffer.append(getClass().getName()).append("@").append(Integer.toHexString(hashCode())).append(" [");

        buffer.append("id").append("='").append(getId()).append("' ");			
        buffer.append("businessId").append("='").append(getBusinessId()).append("' ");			
        buffer.append("parametersValues").append("='").append(getParametersValues()).append("' ");			
        buffer.append("userId").append("='").append(getUserId()).append("' ");			
        buffer.append("logDate").append("='").append(getLogDate()).append("' ");			
        buffer.append("executionTime").append("='").append(getExecutionTime()).append("' ");			
        buffer.append("documentId").append("='").append(getDocumentId()).append("' ");			
        buffer.append("]");
      
        return buffer.toString();
    }

    /**
     * Compares the String representation of the JasperReportLog object
     *
     * @param other The object to compare to
     *
     * @return true of the objects are equal
     */
    public boolean equals(JasperReportLog other) {
        	return this.toString().equals(other.toString());
    }
    /**
     * @see pt.digitalis.utils.common.IBeanAttributes#setAttributeFromString(java.lang.String, java.lang.String)
     */
    public void setAttributeFromString(String attributeName, String attributeValue) {
        if ("id".equalsIgnoreCase(attributeName))
            this.id = Long.valueOf(attributeValue);

        if ("businessId".equalsIgnoreCase(attributeName))
        	this.businessId = attributeValue;

        if ("parametersValues".equalsIgnoreCase(attributeName))
        	this.parametersValues = attributeValue;

        if ("userId".equalsIgnoreCase(attributeName))
        	this.userId = attributeValue;

        if ("logDate".equalsIgnoreCase(attributeName))
	        try {
        	    this.logDate = DateUtils.stringToSimpleDate(attributeValue);
	        } catch (ParseException e) {
	            // Do nothing. The value will not be set!
	        }

        if ("executionTime".equalsIgnoreCase(attributeName))
            this.executionTime = Long.valueOf(attributeValue);

        if ("documentId".equalsIgnoreCase(attributeName))
            this.documentId = Long.valueOf(attributeValue);

    }


}
