-----------------------------------------------------------------------------------------------------------------------
--- SERVER table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.SERVER
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  NAME                   VARCHAR(500) NOT NULL       COMMENT 'The server name',
  MACHINE_SERVER_UID     VARCHAR(200) NOT NULL       COMMENT 'The machine server UID',
  IP_ADDRESS             VARCHAR(100) NOT NULL       COMMENT 'The IP address',
  CONTEXT_ROOT           VARCHAR(100) NOT NULL       COMMENT 'The app context root',
  PORT                   VARCHAR(10) NOT NULL        COMMENT 'The server HTTP port',
  ENDPOINT_BASE_URL      VARCHAR(500) NOT NULL       COMMENT 'The server HTTP base URL',
  BOOT_TIME              DATETIME NOT NULL           COMMENT 'Server startup time stamp',
  LAST_SYNC              DATETIME NOT NULL           COMMENT 'Last sync done by the server',
  ACTIVE                 TINYINT(1) NOT NULL         COMMENT 'If the server is active',
  MISSING                TINYINT(1) NOT NULL         COMMENT 'If the server is missing (too long since keep alive sync)',
  PRIMARY KEY (`ID`), 
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$


-----------------------------------------------------------------------------------------------------------------------
--- SERVER_ACTIVITY_LOG table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.SERVER_ACTIVITY_LOG
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  SERVER_ID              INT NOT NULL                COMMENT 'The server ID',
  BOOT_TIME              DATETIME NOT NULL           COMMENT 'Server startup time stamp',
  LAST_SYNC              DATETIME NOT NULL           COMMENT 'Last sync done by the server',
  PRIMARY KEY (`ID`), 
  CONSTRAINT `FK_SERVER_ACT_LOG_SERVER` FOREIGN KEY (`SERVER_ID`) REFERENCES `SERVER` (`ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$


-----------------------------------------------------------------------------------------------------------------------
--- SERVER_MESSAGE table
-----------------------------------------------------------------------------------------------------------------------

DELIMITER $$
CREATE TABLE IF NOT EXISTS DIF.SERVER_MESSAGE
(
  ID                     INT NOT NULL AUTO_INCREMENT COMMENT 'ID', 
  SERVER_SENDER_ID       INT NOT NULL                COMMENT 'The sender server ID',
  SERVER_RECEIVER_ID     INT NOT NULL                COMMENT 'The receiver server ID',
  MESSAGE                VARCHAR(4000) NOT NULL      COMMENT 'Message sent',
  WHEN                   DATETIME NOT NULL           COMMENT 'Message time stamp',
  ANSWER                 VARCHAR(4000)               COMMENT 'Answer received',
  PROCESSED              TINYINT(1) NOT NULL         COMMENT 'If the message was processed by the receiver',
  SUCCESS                TINYINT(1) NOT NULL         COMMENT 'If the message was successfully executed',
  ELAPSED_TIME           INT NOT NULL                COMMENT 'Time elapsed to get an answer',
  PRIMARY KEY (`ID`), 
  CONSTRAINT `FK_SRV_MSG_LOG_SENDER_SRV` FOREIGN KEY (`SERVER_SENDER_ID`) REFERENCES `SERVER` (`ID`),
  CONSTRAINT `FK_SRV_MSG_LOG_RECEIVER_SRV` FOREIGN KEY (`SERVER_RECEIVER_ID`) REFERENCES `SERVER` (`ID`)
)ENGINE=INNODB DEFAULT CHARSET=UTF8 COLLATE=UTF8_BIN$$
