package pt.digitalis.dif.dem.managers.impl.model.dao.auto;


import java.util.List;

import pt.digitalis.dif.dem.managers.impl.model.data.UserPreferences;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.model.dataset.IDataSet;


/**
 * Home object for domain model class UserPreferences.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.UserPreferences
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public interface IAutoUserPreferencesDAO extends IHibernateDAO<UserPreferences> {

    /**
     * Obtains a new DataSet for the UserPreferences entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserPreferences> getUserPreferencesDataSet();

	/**
	 * Persist a UserPreferences object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(UserPreferences transientInstance);

	/**
	 * Updates a modified UserPreferences in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(UserPreferences instance);

	/**
	 * Attach an unmodified UserPreferences instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(UserPreferences instance);

	/**
	 * Removes a UserPreferences instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(UserPreferences persistentInstance);

	/**
	 * Merge a UserPreferences instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public UserPreferences merge(UserPreferences detachedInstance);

	/**
	 * Finds a UserPreferences instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public UserPreferences findById( java.lang.Long id);

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findAll();


	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByFieldParcial(UserPreferences.Fields field, String value);

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the configId attribute with the given value
	 *
	 * @param configId to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByConfigId(String configId);

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the userId attribute with the given value
	 *
	 * @param userId to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByUserId(String userId);

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the attributeKey attribute with the given value
	 *
	 * @param attributeKey to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByAttributeKey(String attributeKey);

	/**
	 * Gets a {@link List} of all UserPreferences instances
	 * in the persistence layer than match the attributeValue attribute with the given value
	 *
	 * @param attributeValue to match
	 * @return the {@link List} of instances
	 */
    public List<UserPreferences> findByAttributeValue(String attributeValue);
}
