package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.Filter;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoFilterDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class Filter.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.Filter
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoFilterDAOImpl implements IAutoFilterDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the Filter entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Filter> getFilterDataSet()
    {
        return new HibernateDataSet<Filter>(Filter.class, this, Filter.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoFilterDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a Filter object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(Filter transientInstance) {
        logger.debug("persisting Filter instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified Filter in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(Filter instance) {
        logger.debug("attaching dirty Filter instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified Filter instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(Filter instance) {
        logger.debug("attaching clean Filter instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a Filter instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(Filter persistentInstance) {
        logger.debug("deleting Filter instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a Filter instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public Filter merge(Filter detachedInstance) {
        logger.debug("merging Filter instance");
        Filter result = (Filter) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a Filter instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public Filter findById( java.lang.Long id) {
        logger.debug("getting Filter instance with id: " + id);
        Filter instance = (Filter) getSession()
                .get(Filter.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Filter> findAll() {

 		List<Filter> instances = new ArrayList<Filter>();
		logger.debug("getting all Filter instances");
        instances = getSession().createCriteria(Filter.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<Filter>) instances;
    }


	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<Filter> findByExample(Filter instance) {
        logger.debug("finding Filter instance by example");
        List<Filter> results = (List<Filter>) getSession()
                .createCriteria(Filter.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<Filter> findByFieldParcial(Filter.Fields field, String value) {
        logger.debug("finding Filter instance by parcial value: "+field+" like "+value);
        List<Filter> results = (List<Filter>) getSession()
                .createCriteria(Filter.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the uniqueId attribute with the given value
	 *
	 * @param uniqueId to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByUniqueId(String uniqueId) {
        Filter instance = new Filter();

        instance.setUniqueId(uniqueId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the title attribute with the given value
	 *
	 * @param title to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByTitle(String title) {
        Filter instance = new Filter();

        instance.setTitle(title);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the description attribute with the given value
	 *
	 * @param description to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByDescription(String description) {
        Filter instance = new Filter();

        instance.setDescription(description);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the bindToProfile attribute with the given value
	 *
	 * @param bindToProfile to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByBindToProfile(String bindToProfile) {
        Filter instance = new Filter();

        instance.setBindToProfile(bindToProfile);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the type attribute with the given value
	 *
	 * @param type to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByType(Character type) {
        Filter instance = new Filter();

        instance.setType(type);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the defaultValue attribute with the given value
	 *
	 * @param defaultValue to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByDefaultValue(String defaultValue) {
        Filter instance = new Filter();

        instance.setDefaultValue(defaultValue);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the sqlTemplate attribute with the given value
	 *
	 * @param sqlTemplate to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findBySqlTemplate(String sqlTemplate) {
        Filter instance = new Filter();

        instance.setSqlTemplate(sqlTemplate);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the itemsQuerySql attribute with the given value
	 *
	 * @param itemsQuerySql to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByItemsQuerySql(String itemsQuerySql) {
        Filter instance = new Filter();

        instance.setItemsQuerySql(itemsQuerySql);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all Filter instances
	 * in the persistence layer than match the itemsList attribute with the given value
	 *
	 * @param itemsList to match
	 * @return the {@link List} of instances
	 */
    public List<Filter> findByItemsList(String itemsList) {
        Filter instance = new Filter();

        instance.setItemsList(itemsList);

        return findByExample(instance);
    }

}

