package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.JasperReportConfig;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoJasperReportConfigDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class JasperReportConfig.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.JasperReportConfig
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoJasperReportConfigDAOImpl implements IAutoJasperReportConfigDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the JasperReportConfig entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<JasperReportConfig> getJasperReportConfigDataSet()
    {
        return new HibernateDataSet<JasperReportConfig>(JasperReportConfig.class, this, JasperReportConfig.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoJasperReportConfigDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a JasperReportConfig object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(JasperReportConfig transientInstance) {
        logger.debug("persisting JasperReportConfig instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified JasperReportConfig in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(JasperReportConfig instance) {
        logger.debug("attaching dirty JasperReportConfig instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified JasperReportConfig instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(JasperReportConfig instance) {
        logger.debug("attaching clean JasperReportConfig instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a JasperReportConfig instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(JasperReportConfig persistentInstance) {
        logger.debug("deleting JasperReportConfig instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a JasperReportConfig instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public JasperReportConfig merge(JasperReportConfig detachedInstance) {
        logger.debug("merging JasperReportConfig instance");
        JasperReportConfig result = (JasperReportConfig) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a JasperReportConfig instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public JasperReportConfig findById( java.lang.Long id) {
        logger.debug("getting JasperReportConfig instance with id: " + id);
        JasperReportConfig instance = (JasperReportConfig) getSession()
                .get(JasperReportConfig.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all JasperReportConfig instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportConfig> findAll() {

 		List<JasperReportConfig> instances = new ArrayList<JasperReportConfig>();
		logger.debug("getting all JasperReportConfig instances");
        instances = getSession().createCriteria(JasperReportConfig.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<JasperReportConfig>) instances;
    }


	/**
	 * Gets a {@link List} of all JasperReportConfig instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<JasperReportConfig> findByExample(JasperReportConfig instance) {
        logger.debug("finding JasperReportConfig instance by example");
        List<JasperReportConfig> results = (List<JasperReportConfig>) getSession()
                .createCriteria(JasperReportConfig.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all JasperReportConfig instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<JasperReportConfig> findByFieldParcial(JasperReportConfig.Fields field, String value) {
        logger.debug("finding JasperReportConfig instance by parcial value: "+field+" like "+value);
        List<JasperReportConfig> results = (List<JasperReportConfig>) getSession()
                .createCriteria(JasperReportConfig.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all JasperReportConfig instances
	 * in the persistence layer than match the businessId attribute with the given value
	 *
	 * @param businessId to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportConfig> findByBusinessId(String businessId) {
        JasperReportConfig instance = new JasperReportConfig();

        instance.setBusinessId(businessId);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all JasperReportConfig instances
	 * in the persistence layer than match the parametersValues attribute with the given value
	 *
	 * @param parametersValues to match
	 * @return the {@link List} of instances
	 */
    public List<JasperReportConfig> findByParametersValues(String parametersValues) {
        JasperReportConfig instance = new JasperReportConfig();

        instance.setParametersValues(parametersValues);

        return findByExample(instance);
    }

}

