/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoConfigNodeDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigNode;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoConfigNodeDAOImpl
implements IAutoConfigNodeDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ConfigNode> getConfigNodeDataSet() {
        return new HibernateDataSet(ConfigNode.class, (IHibernateDAO)this, ConfigNode.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(ConfigNode transientInstance) {
        this.logger.debug((Object)"persisting ConfigNode instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ConfigNode instance) {
        this.logger.debug((Object)"attaching dirty ConfigNode instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ConfigNode instance) {
        this.logger.debug((Object)"attaching clean ConfigNode instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ConfigNode persistentInstance) {
        this.logger.debug((Object)"deleting ConfigNode instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ConfigNode merge(ConfigNode detachedInstance) {
        this.logger.debug((Object)"merging ConfigNode instance");
        ConfigNode result = (ConfigNode)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ConfigNode findById(Long id) {
        this.logger.debug((Object)("getting ConfigNode instance with id: " + id));
        ConfigNode instance = (ConfigNode)this.getSession().get(ConfigNode.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ConfigNode> findAll() {
        List<ConfigNode> instances = new ArrayList();
        this.logger.debug((Object)"getting all ConfigNode instances");
        instances = this.getSession().createCriteria(ConfigNode.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ConfigNode> findByExample(ConfigNode instance) {
        this.logger.debug((Object)"finding ConfigNode instance by example");
        List results = this.getSession().createCriteria(ConfigNode.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ConfigNode> findByFieldParcial(ConfigNode.Fields field, String value) {
        this.logger.debug((Object)("finding ConfigNode instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ConfigNode.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ConfigNode> findByNodePath(String nodePath) {
        ConfigNode instance = new ConfigNode();
        instance.setNodePath(nodePath);
        return this.findByExample(instance);
    }
}

