DELIMITER $$

DROP PROCEDURE IF EXISTS createColumn;
$$

CREATE PROCEDURE createColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'CONFIG_SERVER_SET' 
  AND COLUMN_NAME = 'IS_DEFAULT';

  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`CONFIG_SERVER_SET` ADD COLUMN `IS_DEFAULT` TINYINT(1);
    END IF;
END
$$

CALL createColumn();
$$

DROP PROCEDURE IF EXISTS createColumn;
$$

UPDATE DIF.CONFIG_SERVER_SET SET IS_DEFAULT = 1
 WHERE (SERVER_UID, CONFIG_SET_ID) IN (SELECT SERVER_UID, MIN(CONFIG_SET_ID) FROM DIF.CONFIG_SERVER_SET GROUP BY SERVER_UID);
$$

UPDATE DIF.CONFIG_SERVER_SET SET IS_DEFAULT = 0 WHERE IS_DEFAULT IS NULL;
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$

CREATE PROCEDURE updateColumn()
BEGIN
  DECLARE TOTAL INT;

  SELECT COUNT(*)
  INTO TOTAL
  FROM information_schema.COLUMNS 
  WHERE TABLE_SCHEMA = 'DIF' 
  AND TABLE_NAME = 'CONFIG_SERVER_SET' 
  AND COLUMN_NAME = 'IS_VISIBLE'
  AND IS_NULLABLE = 'NO';
  
  IF TOTAL = 0 THEN
    ALTER TABLE `DIF`.`CONFIG_SERVER_SET` CHANGE COLUMN `IS_DEFAULT` TINYINT(1) NOT NULL COMMENT 'If set is the default';
  END IF;
END
$$

CALL updateColumn();
$$

DROP PROCEDURE IF EXISTS updateColumn;
$$
