package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoErrorLogDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ErrorLog.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ErrorLog
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoErrorLogDAOImpl implements IAutoErrorLogDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ErrorLog entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ErrorLog> getErrorLogDataSet()
    {
        return new HibernateDataSet<ErrorLog>(ErrorLog.class, this, ErrorLog.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoErrorLogDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ErrorLog object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ErrorLog transientInstance) {
        logger.debug("persisting ErrorLog instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ErrorLog in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ErrorLog instance) {
        logger.debug("attaching dirty ErrorLog instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ErrorLog instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ErrorLog instance) {
        logger.debug("attaching clean ErrorLog instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ErrorLog instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ErrorLog persistentInstance) {
        logger.debug("deleting ErrorLog instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ErrorLog instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ErrorLog merge(ErrorLog detachedInstance) {
        logger.debug("merging ErrorLog instance");
        ErrorLog result = (ErrorLog) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ErrorLog instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ErrorLog findById( java.lang.Long id) {
        logger.debug("getting ErrorLog instance with id: " + id);
        ErrorLog instance = (ErrorLog) getSession()
                .get(ErrorLog.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ErrorLog instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ErrorLog> findAll() {

 		List<ErrorLog> instances = new ArrayList<ErrorLog>();
		logger.debug("getting all ErrorLog instances");
        instances = getSession().createCriteria(ErrorLog.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ErrorLog>) instances;
    }


	/**
	 * Gets a {@link List} of all ErrorLog instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ErrorLog> findByExample(ErrorLog instance) {
        logger.debug("finding ErrorLog instance by example");
        List<ErrorLog> results = (List<ErrorLog>) getSession()
                .createCriteria(ErrorLog.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ErrorLog instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ErrorLog> findByFieldParcial(ErrorLog.Fields field, String value) {
        logger.debug("finding ErrorLog instance by parcial value: "+field+" like "+value);
        List<ErrorLog> results = (List<ErrorLog>) getSession()
                .createCriteria(ErrorLog.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ErrorLog instances
	 * in the persistence layer than match the processName attribute with the given value
	 *
	 * @param processName to match
	 * @return the {@link List} of instances
	 */
    public List<ErrorLog> findByProcessName(String processName) {
        ErrorLog instance = new ErrorLog();

        instance.setProcessName(processName);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ErrorLog instances
	 * in the persistence layer than match the errorDescription attribute with the given value
	 *
	 * @param errorDescription to match
	 * @return the {@link List} of instances
	 */
    public List<ErrorLog> findByErrorDescription(String errorDescription) {
        ErrorLog instance = new ErrorLog();

        instance.setErrorDescription(errorDescription);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ErrorLog instances
	 * in the persistence layer than match the erroDate attribute with the given value
	 *
	 * @param erroDate to match
	 * @return the {@link List} of instances
	 */
    public List<ErrorLog> findByErroDate(Date erroDate) {
        ErrorLog instance = new ErrorLog();

        instance.setErroDate(erroDate);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ErrorLog instances
	 * in the persistence layer than match the appName attribute with the given value
	 *
	 * @param appName to match
	 * @return the {@link List} of instances
	 */
    public List<ErrorLog> findByAppName(String appName) {
        ErrorLog instance = new ErrorLog();

        instance.setAppName(appName);

        return findByExample(instance);
    }

}

