package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;


import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import static org.hibernate.criterion.Example.create;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.log.ILogWrapper;

import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaSql;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportInstanceAreaSqlDAO;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;

/**
 * Home object for domain model class ReportInstanceAreaSql.
 * Generated by ORM Generator
 * DIF build process for the Model layer
 *
 * @see pt.digitalis.dif.dem.managers.impl.model.data.ReportInstanceAreaSql
 * @author <a href="mailto:dif@digitalis.pt>DIF Team</a>
 */
public abstract class AutoReportInstanceAreaSqlDAOImpl implements IAutoReportInstanceAreaSqlDAO {

    /** The logger instance */
    protected ILogWrapper logger;

    /**
     * Obtains a new DataSet for the ReportInstanceAreaSql entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<ReportInstanceAreaSql> getReportInstanceAreaSqlDataSet()
    {
        return new HibernateDataSet<ReportInstanceAreaSql>(ReportInstanceAreaSql.class, this, ReportInstanceAreaSql.getPKFieldListAsString());
    }

	/**
	 * Retrieves the injected {@link Session} object
	 *
	 * @return the session
	 */
    public Session getSession() {
	    return DIFRepositoryFactory.getSession();
	}

	/**
	 * Constructor
	 */
	public AutoReportInstanceAreaSqlDAOImpl() {
        this.logger = DIFLogger.getLogger();
	}

	/**
	 * Persist a ReportInstanceAreaSql object to the persistence layer
	 *
	 * @param transientInstance to persist
	 */
    public void persist(ReportInstanceAreaSql transientInstance) {
        logger.debug("persisting ReportInstanceAreaSql instance");
        getSession().persist(transientInstance);
        logger.debug("persist successful");
    }

	/**
	 * Updates a modified ReportInstanceAreaSql in the persistence layer
	 * and reattaches them together
	 *
	 * @param instance to update/attach
	 */
    public void attachDirty(ReportInstanceAreaSql instance) {
        logger.debug("attaching dirty ReportInstanceAreaSql instance");
        getSession().saveOrUpdate(instance);
        logger.debug("attach successful");
    }

	/**
	 * Attach an unmodified ReportInstanceAreaSql instance in the
	 * persistence layer
	 *
	 * @param instance to attach
	 */
    public void attachClean(ReportInstanceAreaSql instance) {
        logger.debug("attaching clean ReportInstanceAreaSql instance");
        getSession().buildLockRequest(LockOptions.NONE).lock(instance);
        logger.debug("attach successful");
    }

	/**
	 * Removes a ReportInstanceAreaSql instance from the persistence layer
	 *
	 * @param persistentInstance to remove/deletes
	 */
    public void delete(ReportInstanceAreaSql persistentInstance) {
        logger.debug("deleting ReportInstanceAreaSql instance");
        getSession().delete(persistentInstance);
        logger.debug("delete successful");
    }

	/**
	 * Merge a ReportInstanceAreaSql instance back to the persistence layer
	 * updating it with the given instance data
	 *
	 * @param detachedInstance to update/merge
	 * @return the merged instance
	 */
    public ReportInstanceAreaSql merge(ReportInstanceAreaSql detachedInstance) {
        logger.debug("merging ReportInstanceAreaSql instance");
        ReportInstanceAreaSql result = (ReportInstanceAreaSql) getSession().merge(detachedInstance);
        logger.debug("merge successful");

        return result;
    }

	/**
	 * Finds a ReportInstanceAreaSql instance in the persistence layer
	 * with the given id
	 *
	 * @param id to search
	 * @return the found instance
	 */
    public ReportInstanceAreaSql findById( java.lang.Long id) {
        logger.debug("getting ReportInstanceAreaSql instance with id: " + id);
        ReportInstanceAreaSql instance = (ReportInstanceAreaSql) getSession()
                .get(ReportInstanceAreaSql.class, id);
        if (instance==null)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instance found");

        return instance;
    }
	/**
	 * Gets a {@link List} of all ReportInstanceAreaSql instances
	 * in the persistence layer
	 *
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceAreaSql> findAll() {

 		List<ReportInstanceAreaSql> instances = new ArrayList<ReportInstanceAreaSql>();
		logger.debug("getting all ReportInstanceAreaSql instances");
        instances = getSession().createCriteria(ReportInstanceAreaSql.class).list();
        if (instances.size()>0)
            logger.debug("get successful, no instance found");
        else
            logger.debug("get successful, instances found");

        return (List<ReportInstanceAreaSql>) instances;
    }


	/**
	 * Gets a {@link List} of all ReportInstanceAreaSql instances
	 * in the persistence layer than match the example of the given instance
	 *
	 * @param instance to use as an example to the search
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    protected List<ReportInstanceAreaSql> findByExample(ReportInstanceAreaSql instance) {
        logger.debug("finding ReportInstanceAreaSql instance by example");
        List<ReportInstanceAreaSql> results = (List<ReportInstanceAreaSql>) getSession()
                .createCriteria(ReportInstanceAreaSql.class)
                .add( create(instance) )
        .list();
        logger.debug("find by example successful, result size: " + results.size());

        return results;
    }

	/**
	 * Gets a {@link List} of all ReportInstanceAreaSql instances
	 * in the persistence layer than partially match the given field with the given value
	 *
	 * @param field to match against
	 * @param value to match
	 * @return the {@link List} of instances
	 */
    @SuppressWarnings("unchecked")
    public List<ReportInstanceAreaSql> findByFieldParcial(ReportInstanceAreaSql.Fields field, String value) {
        logger.debug("finding ReportInstanceAreaSql instance by parcial value: "+field+" like "+value);
        List<ReportInstanceAreaSql> results = (List<ReportInstanceAreaSql>) getSession()
                .createCriteria(ReportInstanceAreaSql.class)
                .add( Restrictions.like(field.toString(), value, MatchMode.ANYWHERE).ignoreCase() )
        .list();
        logger.debug("find by parcial value successful, result size: " + results.size());

        return results;
    }


	/**
	 * Gets a {@link List} of all ReportInstanceAreaSql instances
	 * in the persistence layer than match the name attribute with the given value
	 *
	 * @param name to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaSql> findByName(String name) {
        ReportInstanceAreaSql instance = new ReportInstanceAreaSql();

        instance.setName(name);

        return findByExample(instance);
    }

	/**
	 * Gets a {@link List} of all ReportInstanceAreaSql instances
	 * in the persistence layer than match the sql attribute with the given value
	 *
	 * @param sql to match
	 * @return the {@link List} of instances
	 */
    public List<ReportInstanceAreaSql> findBySql(String sql) {
        ReportInstanceAreaSql instance = new ReportInstanceAreaSql();

        instance.setSql(sql);

        return findByExample(instance);
    }

}

