package pt.digitalis.dif.dem.managers.impl.model.impl;

import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.utils.common.IBeanAttributes;

import pt.digitalis.dif.dem.managers.impl.model.IIdentityService;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUsersDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.UsersDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Users;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUserAttributesDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.UserAttributesDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.UserAttributes;
import pt.digitalis.dif.dem.managers.impl.model.dao.IGroupsDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.GroupsDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.Groups;
import pt.digitalis.dif.dem.managers.impl.model.dao.IUserGroupsDAO;
import pt.digitalis.dif.dem.managers.impl.model.dao.impl.UserGroupsDAOImpl;
import pt.digitalis.dif.dem.managers.impl.model.data.UserGroups;

/**
 * NOTE: This file is auto generated and will be overwrite in a future file generation.
 */
public class IdentityServiceImpl implements IIdentityService {

	/**
	 * Obtains a new Users DAO
	 *
	 * @return A new IUsersDAO
	 */
    public IUsersDAO getUsersDAO() {
    	return new UsersDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Users entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Users> getUsersDataSet() {
        return new HibernateDataSet<Users>(Users.class, new UsersDAOImpl(),
                Users.getPKFieldListAsString());
    }

	/**
	 * Obtains a new UserAttributes DAO
	 *
	 * @return A new IUserAttributesDAO
	 */
    public IUserAttributesDAO getUserAttributesDAO() {
    	return new UserAttributesDAOImpl();
    }

    /**
     * Obtains a new DataSet for the UserAttributes entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserAttributes> getUserAttributesDataSet() {
        return new HibernateDataSet<UserAttributes>(UserAttributes.class, new UserAttributesDAOImpl(),
                UserAttributes.getPKFieldListAsString());
    }

	/**
	 * Obtains a new Groups DAO
	 *
	 * @return A new IGroupsDAO
	 */
    public IGroupsDAO getGroupsDAO() {
    	return new GroupsDAOImpl();
    }

    /**
     * Obtains a new DataSet for the Groups entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<Groups> getGroupsDataSet() {
        return new HibernateDataSet<Groups>(Groups.class, new GroupsDAOImpl(),
                Groups.getPKFieldListAsString());
    }

	/**
	 * Obtains a new UserGroups DAO
	 *
	 * @return A new IUserGroupsDAO
	 */
    public IUserGroupsDAO getUserGroupsDAO() {
    	return new UserGroupsDAOImpl();
    }

    /**
     * Obtains a new DataSet for the UserGroups entity
     *
     * @return A new IDataSet instance
     */
    public IDataSet<UserGroups> getUserGroupsDataSet() {
        return new HibernateDataSet<UserGroups>(UserGroups.class, new UserGroupsDAOImpl(),
                UserGroups.getPKFieldListAsString());
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param clazz
     *            the entity class
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(Class<? extends IBeanAttributes> clazz) {

        if (clazz == Users.class)
            return getUsersDataSet();

        if (clazz == UserAttributes.class)
            return getUserAttributesDataSet();

        if (clazz == Groups.class)
            return getGroupsDataSet();

        if (clazz == UserGroups.class)
            return getUserGroupsDataSet();

        return null;
    }

    /**
     * Obtains a IDataSet for the given entity class
     *
     * @param entityName
     *            the entity class simple name
     * @return A new IDataSet instance
     */
    public IDataSet<? extends IBeanAttributes> getDataSet(String entityName) {

        if (entityName.equalsIgnoreCase(Users.class.getSimpleName()))
            return getUsersDataSet();

        if (entityName.equalsIgnoreCase(UserAttributes.class.getSimpleName()))
            return getUserAttributesDataSet();

        if (entityName.equalsIgnoreCase(Groups.class.getSimpleName()))
            return getGroupsDataSet();

        if (entityName.equalsIgnoreCase(UserGroups.class.getSimpleName()))
            return getUserGroupsDataSet();

        return null;
    }
}