/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.ecommerce;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.utils.IObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.dif.utils.ObjectFormatter.Format;

/**
 * The Payment request definition
 * 
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created May 10, 2012
 */
public class PaymentRequest implements IObjectFormatter {

    /** The amount. */
    private BigDecimal amount;

    /** The business context. */
    private String businessContext;

    /** The buyer address */
    protected String buyerAddress;

    /** The buyer address postal code */
    protected String buyerAddressCity;

    /** The buyer address postal code */
    protected String buyerAddressPostalCode;

    /** The buyer card CVV2 code */
    protected String buyerCardCVV2Code;

    /** The buyer card expiration date */
    protected String buyerCardExpirationDate;

    /** The buyer card number */
    protected String buyerCardNumber;

    /** The buyer email. */
    protected String buyerEmail;

    /** The buyer first name. */
    protected String buyerFirstName;

    /** The buyer last name. */
    protected String buyerLastName;

    /** the buyer telefone */
    protected String buyerTelefone;

    /** The cancel url. */
    private String cancelURL;

    /** The context. */
    private final IDIFContext context;

    /** The country in ISO 3166. */
    private String country;

    /** The creator. */
    private String creator;

    /** The currency ISO 4217. */
    private Long currency;

    /** The payment fee */
    private BigDecimal fee;

    /** the payment itens with id and description */
    private Map<String, String> itens = new HashMap<String, String>();

    /** The payment context. */
    private Map<String, String> paymentContext;

    /** The return url. */
    private String returnURL;

    /**
     * Instantiates a new payment request.
     * 
     * @param context
     *            the context
     */
    PaymentRequest(IDIFContext context)
    {
        super();
        this.context = context;
    }

    /**
     * @param id
     * @param desc
     */
    public void addItem(String id, String desc)
    {
        itens.put(id, desc);
    }

    /**
     * Inspector for the 'amount' attribute.
     * 
     * @return the amount value
     */
    public BigDecimal getAmount()
    {
        return amount;
    }

    /**
     * Inspector for the 'businessContext' attribute.
     * 
     * @return the businessContext value
     */
    public String getBusinessContext()
    {
        return businessContext;
    }

    /**
     * Inspector for the 'buyerAddress' attribute.
     * 
     * @return the buyerAddress value
     */
    public String getBuyerAddress()
    {
        return buyerAddress;
    }

    /**
     * Inspector for the 'buyerAddressCity' attribute.
     * 
     * @return the buyerAddressCity value
     */
    public String getBuyerAddressCity()
    {
        return buyerAddressCity;
    }

    /**
     * Inspector for the 'buyerAddressPostalCode' attribute.
     * 
     * @return the buyerAddressPostalCode value
     */
    public String getBuyerAddressPostalCode()
    {
        return buyerAddressPostalCode;
    }

    /**
     * Inspector for the 'buyerCardCVV2Code' attribute.
     * 
     * @return the buyerCardCVV2Code value
     */
    public String getBuyerCardCVV2Code()
    {
        return buyerCardCVV2Code;
    }

    /**
     * Inspector for the 'buyerCardExpirationDate' attribute.
     * 
     * @return the buyerCardExpirationDate value
     */
    public String getBuyerCardExpirationDate()
    {
        return buyerCardExpirationDate;
    }

    /**
     * Inspector for the 'buyerCardNumber' attribute.
     * 
     * @return the buyerCardNumber value
     */
    public String getBuyerCardNumber()
    {
        return buyerCardNumber;
    }

    /**
     * Inspector for the 'buyerEmail' attribute.
     * 
     * @return the buyerEmail value
     */
    public String getBuyerEmail()
    {
        return buyerEmail;
    }

    /**
     * Inspector for the 'buyerFirstName' attribute.
     * 
     * @return the buyerFirstName value
     */
    public String getBuyerFirstName()
    {
        return buyerFirstName;
    }

    /**
     * Inspector for the 'buyerLastName' attribute.
     * 
     * @return the buyerLastName value
     */
    public String getBuyerLastName()
    {
        return buyerLastName;
    }

    /**
     * Inspector for the 'buyerTelefone' attribute.
     * 
     * @return the buyerTelefone value
     */
    public String getBuyerTelefone()
    {
        return buyerTelefone;
    }

    /**
     * Inspector for the 'cancelURL' attribute.
     * 
     * @return the cancelURL value
     */
    public String getCancelURL()
    {
        return cancelURL;
    }

    /**
     * Inspector for the 'context' attribute.
     * 
     * @return the context value
     */
    public IDIFContext getContext()
    {
        return context;
    }

    /**
     * Inspector for the 'country' attribute.
     * 
     * @return the country value
     */
    public String getCountry()
    {
        return country;
    }

    /**
     * Inspector for the 'creator' attribute.
     * 
     * @return the creator value
     */
    public String getCreator()
    {
        return creator;
    }

    /**
     * Inspector for the 'currency' attribute.
     * 
     * @return the currency value
     */
    public Long getCurrency()
    {
        return currency;
    }

    /**
     * @return the fee
     */
    public BigDecimal getFee()
    {
        return fee;
    }

    /**
     * Inspector for the 'itens' attribute.
     * 
     * @return the itens value
     */
    public Map<String, String> getItens()
    {
        return itens;
    }

    /**
     * Inspector for the 'paymentContext' attribute.
     *
     * @return the paymentContext value
     */
    public Map<String, String> getPaymentContext()
    {
        return paymentContext;
    }

    /**
     * Inspector for the 'returnURL' attribute.
     * 
     * @return the returnURL value
     */
    public String getReturnURL()
    {
        return returnURL;
    }

    /**
     * Modifier for the 'amount' attribute.
     * 
     * @param amount
     *            the new amount value to set
     */
    public void setAmount(BigDecimal amount)
    {
        this.amount = amount;
    }

    /**
     * Modifier for the 'businessContext' attribute.
     * 
     * @param businessContext
     *            the new businessContext value to set
     */
    public void setBusinessContext(String businessContext)
    {
        this.businessContext = businessContext;
    }

    /**
     * Modifier for the 'buyerAddress' attribute.
     * 
     * @param buyerAddress
     *            the new buyerAddress value to set
     */
    public void setBuyerAddress(String buyerAddress)
    {
        this.buyerAddress = buyerAddress;
    }

    /**
     * Modifier for the 'buyerAddressCity' attribute.
     * 
     * @param buyerAddressCity
     *            the new buyerAddressCity value to set
     */
    public void setBuyerAddressCity(String buyerAddressCity)
    {
        this.buyerAddressCity = buyerAddressCity;
    }

    /**
     * Modifier for the 'buyerAddressPostalCode' attribute.
     * 
     * @param buyerAddressPostalCode
     *            the new buyerAddressPostalCode value to set
     */
    public void setBuyerAddressPostalCode(String buyerAddressPostalCode)
    {
        this.buyerAddressPostalCode = buyerAddressPostalCode;
    }

    /**
     * Modifier for the 'buyerCardCVV2Code' attribute.
     * 
     * @param buyerCardCVV2Code
     *            the new buyerCardCVV2Code value to set
     */
    public void setBuyerCardCVV2Code(String buyerCardCVV2Code)
    {
        this.buyerCardCVV2Code = buyerCardCVV2Code;
    }

    /**
     * Modifier for the 'buyerCardExpirationDate' attribute.
     * 
     * @param buyerCardExpirationDate
     *            the new buyerCardExpirationDate value to set
     */
    public void setBuyerCardExpirationDate(String buyerCardExpirationDate)
    {
        this.buyerCardExpirationDate = buyerCardExpirationDate;
    }

    /**
     * Modifier for the 'buyerCardNumber' attribute.
     * 
     * @param buyerCardNumber
     *            the new buyerCardNumber value to set
     */
    public void setBuyerCardNumber(String buyerCardNumber)
    {
        this.buyerCardNumber = buyerCardNumber;
    }

    /**
     * Modifier for the 'buyerEmail' attribute.
     * 
     * @param buyerEmail
     *            the new buyerEmail value to set
     */
    public void setBuyerEmail(String buyerEmail)
    {
        this.buyerEmail = buyerEmail;
    }

    /**
     * Modifier for the 'buyerFirstName' attribute.
     * 
     * @param buyerFirstName
     *            the new buyerFirstName value to set
     */
    public void setBuyerFirstName(String buyerFirstName)
    {
        this.buyerFirstName = buyerFirstName;
    }

    /**
     * Modifier for the 'buyerLastName' attribute.
     * 
     * @param buyerLastName
     *            the new buyerLastName value to set
     */
    public void setBuyerLastName(String buyerLastName)
    {
        this.buyerLastName = buyerLastName;
    }

    /**
     * Modifier for the 'buyerTelefone' attribute.
     * 
     * @param buyerTelefone
     *            the new buyerTelefone value to set
     */
    public void setBuyerTelefone(String buyerTelefone)
    {
        this.buyerTelefone = buyerTelefone;
    }

    /**
     * Modifier for the 'cancelURL' attribute.
     * 
     * @param cancelURL
     *            the new cancelURL value to set
     */
    public void setCancelURL(String cancelURL)
    {
        this.cancelURL = cancelURL;
    }

    /**
     * Modifier for the 'country' attribute.
     * 
     * @param country
     *            the new country value to set
     */
    public void setCountry(String country)
    {
        this.country = country;
    }

    /**
     * Modifier for the 'creator' attribute.
     * 
     * @param creator
     *            the new creator value to set
     */
    void setCreator(String creator)
    {
        this.creator = creator;
    }

    /**
     * Modifier for the 'currency' attribute.
     * 
     * @param currency
     *            the new currency value to set
     */
    public void setCurrency(Long currency)
    {
        this.currency = currency;
    }

    /**
     * @param fee
     *            the fee to set
     */
    public void setFee(BigDecimal fee)
    {
        this.fee = fee;
    }

    /**
     * Modifier for the 'itens' attribute.
     * 
     * @param itens
     *            the new itens value to set
     */
    public void setItens(Map<String, String> itens)
    {
        this.itens = itens;
    }

    /**
     * Modifier for the 'paymentContext' attribute.
     *
     * @param paymentContext
     *            the new paymentContext value to set
     */
    public void setPaymentContext(Map<String, String> paymentContext)
    {
        this.paymentContext = paymentContext;
    }

    /**
     * Modifier for the 'returnURL' attribute.
     * 
     * @param returnURL
     *            the new returnURL value to set
     */
    public void setReturnURL(String returnURL)
    {
        this.returnURL = returnURL;
    }

    /**
     * @see pt.digitalis.dif.utils.IObjectFormatter#toObjectFormatter(pt.digitalis.dif.utils.ObjectFormatter.Format)
     */
    public ObjectFormatter toObjectFormatter(Format format)
    {
        ObjectFormatter formatter = new ObjectFormatter(format);
        formatter.addItem("businessContext", businessContext);
        formatter.addItem("amount", amount);
        formatter.addItem("buyerAddress", buyerAddress);
        formatter.addItem("buyerAddressPostalCode", buyerAddressPostalCode);
        formatter.addItem("buyerAddressCity", buyerAddressCity);
        formatter.addItem("buyerEmail", buyerEmail);
        formatter.addItem("buyerFirstName", buyerFirstName);
        formatter.addItem("buyerLastName", buyerLastName);
        formatter.addItem("buyerTelefone", buyerTelefone);
        formatter.addItem("creator", creator);
        formatter.addItem("currency", currency);
        formatter.addItem("returnURL", returnURL);
        formatter.addItem("cancelURL", cancelURL);

        return formatter;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return toObjectFormatter(Format.TEXT).getFormatedObject();
    }
}
