/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoConfigServerSetDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigServerSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoConfigServerSetDAOImpl
implements IAutoConfigServerSetDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ConfigServerSet> getConfigServerSetDataSet() {
        return new HibernateDataSet(ConfigServerSet.class, (IHibernateDAO)this, ConfigServerSet.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(ConfigServerSet transientInstance) {
        this.logger.debug((Object)"persisting ConfigServerSet instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ConfigServerSet instance) {
        this.logger.debug((Object)"attaching dirty ConfigServerSet instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ConfigServerSet instance) {
        this.logger.debug((Object)"attaching clean ConfigServerSet instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ConfigServerSet persistentInstance) {
        this.logger.debug((Object)"deleting ConfigServerSet instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ConfigServerSet merge(ConfigServerSet detachedInstance) {
        this.logger.debug((Object)"merging ConfigServerSet instance");
        ConfigServerSet result = (ConfigServerSet)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ConfigServerSet findById(Long id) {
        this.logger.debug((Object)("getting ConfigServerSet instance with id: " + id));
        ConfigServerSet instance = (ConfigServerSet)this.getSession().get(ConfigServerSet.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ConfigServerSet> findAll() {
        List<ConfigServerSet> instances = new ArrayList();
        this.logger.debug((Object)"getting all ConfigServerSet instances");
        instances = this.getSession().createCriteria(ConfigServerSet.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ConfigServerSet> findByExample(ConfigServerSet instance) {
        this.logger.debug((Object)"finding ConfigServerSet instance by example");
        List results = this.getSession().createCriteria(ConfigServerSet.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ConfigServerSet> findByFieldParcial(ConfigServerSet.Fields field, String value) {
        this.logger.debug((Object)("finding ConfigServerSet instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ConfigServerSet.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ConfigServerSet> findByServerUid(String serverUid) {
        ConfigServerSet instance = new ConfigServerSet();
        instance.setServerUid(serverUid);
        return this.findByExample(instance);
    }

    @Override
    public List<ConfigServerSet> findByIsDefault(boolean isDefault) {
        ConfigServerSet instance = new ConfigServerSet();
        instance.setIsDefault(isDefault);
        return this.findByExample(instance);
    }
}

