/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoConfigSetDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ConfigSet;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoConfigSetDAOImpl
implements IAutoConfigSetDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ConfigSet> getConfigSetDataSet() {
        return new HibernateDataSet(ConfigSet.class, (IHibernateDAO)this, ConfigSet.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(ConfigSet transientInstance) {
        this.logger.debug((Object)"persisting ConfigSet instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ConfigSet instance) {
        this.logger.debug((Object)"attaching dirty ConfigSet instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ConfigSet instance) {
        this.logger.debug((Object)"attaching clean ConfigSet instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ConfigSet persistentInstance) {
        this.logger.debug((Object)"deleting ConfigSet instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ConfigSet merge(ConfigSet detachedInstance) {
        this.logger.debug((Object)"merging ConfigSet instance");
        ConfigSet result = (ConfigSet)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ConfigSet findById(Long id) {
        this.logger.debug((Object)("getting ConfigSet instance with id: " + id));
        ConfigSet instance = (ConfigSet)this.getSession().get(ConfigSet.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ConfigSet> findAll() {
        List<ConfigSet> instances = new ArrayList();
        this.logger.debug((Object)"getting all ConfigSet instances");
        instances = this.getSession().createCriteria(ConfigSet.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ConfigSet> findByExample(ConfigSet instance) {
        this.logger.debug((Object)"finding ConfigSet instance by example");
        List results = this.getSession().createCriteria(ConfigSet.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ConfigSet> findByFieldParcial(ConfigSet.Fields field, String value) {
        this.logger.debug((Object)("finding ConfigSet instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ConfigSet.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ConfigSet> findByName(String name) {
        ConfigSet instance = new ConfigSet();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<ConfigSet> findByDescription(String description) {
        ConfigSet instance = new ConfigSet();
        instance.setDescription(description);
        return this.findByExample(instance);
    }
}

