/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoConfigurationDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.Configuration;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoConfigurationDAOImpl
implements IAutoConfigurationDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<Configuration> getConfigurationDataSet() {
        return new HibernateDataSet(Configuration.class, (IHibernateDAO)this, Configuration.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(Configuration transientInstance) {
        this.logger.debug((Object)"persisting Configuration instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(Configuration instance) {
        this.logger.debug((Object)"attaching dirty Configuration instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(Configuration instance) {
        this.logger.debug((Object)"attaching clean Configuration instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(Configuration persistentInstance) {
        this.logger.debug((Object)"deleting Configuration instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public Configuration merge(Configuration detachedInstance) {
        this.logger.debug((Object)"merging Configuration instance");
        Configuration result = (Configuration)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public Configuration findById(Long id) {
        this.logger.debug((Object)("getting Configuration instance with id: " + id));
        Configuration instance = (Configuration)this.getSession().get(Configuration.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<Configuration> findAll() {
        List<Configuration> instances = new ArrayList();
        this.logger.debug((Object)"getting all Configuration instances");
        instances = this.getSession().createCriteria(Configuration.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<Configuration> findByExample(Configuration instance) {
        this.logger.debug((Object)"finding Configuration instance by example");
        List results = this.getSession().createCriteria(Configuration.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Configuration> findByFieldParcial(Configuration.Fields field, String value) {
        this.logger.debug((Object)("finding Configuration instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(Configuration.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<Configuration> findByKey(String key) {
        Configuration instance = new Configuration();
        instance.setKey(key);
        return this.findByExample(instance);
    }

    @Override
    public List<Configuration> findByValue(String value) {
        Configuration instance = new Configuration();
        instance.setValue(value);
        return this.findByExample(instance);
    }

    @Override
    public List<Configuration> findByValueXL(String valueXL) {
        Configuration instance = new Configuration();
        instance.setValueXL(valueXL);
        return this.findByExample(instance);
    }
}

