/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoJasperReportLogDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.JasperReportLog;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoJasperReportLogDAOImpl
implements IAutoJasperReportLogDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<JasperReportLog> getJasperReportLogDataSet() {
        return new HibernateDataSet(JasperReportLog.class, (IHibernateDAO)this, JasperReportLog.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(JasperReportLog transientInstance) {
        this.logger.debug((Object)"persisting JasperReportLog instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(JasperReportLog instance) {
        this.logger.debug((Object)"attaching dirty JasperReportLog instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(JasperReportLog instance) {
        this.logger.debug((Object)"attaching clean JasperReportLog instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(JasperReportLog persistentInstance) {
        this.logger.debug((Object)"deleting JasperReportLog instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public JasperReportLog merge(JasperReportLog detachedInstance) {
        this.logger.debug((Object)"merging JasperReportLog instance");
        JasperReportLog result = (JasperReportLog)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public JasperReportLog findById(Long id) {
        this.logger.debug((Object)("getting JasperReportLog instance with id: " + id));
        JasperReportLog instance = (JasperReportLog)this.getSession().get(JasperReportLog.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<JasperReportLog> findAll() {
        List<JasperReportLog> instances = new ArrayList();
        this.logger.debug((Object)"getting all JasperReportLog instances");
        instances = this.getSession().createCriteria(JasperReportLog.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<JasperReportLog> findByExample(JasperReportLog instance) {
        this.logger.debug((Object)"finding JasperReportLog instance by example");
        List results = this.getSession().createCriteria(JasperReportLog.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<JasperReportLog> findByFieldParcial(JasperReportLog.Fields field, String value) {
        this.logger.debug((Object)("finding JasperReportLog instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(JasperReportLog.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<JasperReportLog> findByBusinessId(String businessId) {
        JasperReportLog instance = new JasperReportLog();
        instance.setBusinessId(businessId);
        return this.findByExample(instance);
    }

    @Override
    public List<JasperReportLog> findByParametersValues(String parametersValues) {
        JasperReportLog instance = new JasperReportLog();
        instance.setParametersValues(parametersValues);
        return this.findByExample(instance);
    }

    @Override
    public List<JasperReportLog> findByUserId(String userId) {
        JasperReportLog instance = new JasperReportLog();
        instance.setUserId(userId);
        return this.findByExample(instance);
    }

    @Override
    public List<JasperReportLog> findByLogDate(Date logDate) {
        JasperReportLog instance = new JasperReportLog();
        instance.setLogDate(logDate);
        return this.findByExample(instance);
    }

    @Override
    public List<JasperReportLog> findByExecutionTime(Long executionTime) {
        JasperReportLog instance = new JasperReportLog();
        instance.setExecutionTime(executionTime);
        return this.findByExample(instance);
    }

    @Override
    public List<JasperReportLog> findByDocumentId(Long documentId) {
        JasperReportLog instance = new JasperReportLog();
        instance.setDocumentId(documentId);
        return this.findByExample(instance);
    }
}

