/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoReportTemplateDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ReportTemplate;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoReportTemplateDAOImpl
implements IAutoReportTemplateDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ReportTemplate> getReportTemplateDataSet() {
        return new HibernateDataSet(ReportTemplate.class, (IHibernateDAO)this, ReportTemplate.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(ReportTemplate transientInstance) {
        this.logger.debug((Object)"persisting ReportTemplate instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ReportTemplate instance) {
        this.logger.debug((Object)"attaching dirty ReportTemplate instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ReportTemplate instance) {
        this.logger.debug((Object)"attaching clean ReportTemplate instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ReportTemplate persistentInstance) {
        this.logger.debug((Object)"deleting ReportTemplate instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ReportTemplate merge(ReportTemplate detachedInstance) {
        this.logger.debug((Object)"merging ReportTemplate instance");
        ReportTemplate result = (ReportTemplate)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ReportTemplate findById(Long id) {
        this.logger.debug((Object)("getting ReportTemplate instance with id: " + id));
        ReportTemplate instance = (ReportTemplate)this.getSession().get(ReportTemplate.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ReportTemplate> findAll() {
        List<ReportTemplate> instances = new ArrayList();
        this.logger.debug((Object)"getting all ReportTemplate instances");
        instances = this.getSession().createCriteria(ReportTemplate.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ReportTemplate> findByExample(ReportTemplate instance) {
        this.logger.debug((Object)"finding ReportTemplate instance by example");
        List results = this.getSession().createCriteria(ReportTemplate.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ReportTemplate> findByFieldParcial(ReportTemplate.Fields field, String value) {
        this.logger.debug((Object)("finding ReportTemplate instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ReportTemplate.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ReportTemplate> findByName(String name) {
        ReportTemplate instance = new ReportTemplate();
        instance.setName(name);
        return this.findByExample(instance);
    }

    @Override
    public List<ReportTemplate> findByDescription(String description) {
        ReportTemplate instance = new ReportTemplate();
        instance.setDescription(description);
        return this.findByExample(instance);
    }

    @Override
    public List<ReportTemplate> findByType(String type) {
        ReportTemplate instance = new ReportTemplate();
        instance.setType(type);
        return this.findByExample(instance);
    }

    @Override
    public List<ReportTemplate> findByEnabled(boolean enabled) {
        ReportTemplate instance = new ReportTemplate();
        instance.setEnabled(enabled);
        return this.findByExample(instance);
    }

    @Override
    public List<ReportTemplate> findByTemplateUrl(String templateUrl) {
        ReportTemplate instance = new ReportTemplate();
        instance.setTemplateUrl(templateUrl);
        return this.findByExample(instance);
    }

    @Override
    public List<ReportTemplate> findByTemplateFiles(Blob templateFiles) {
        ReportTemplate instance = new ReportTemplate();
        instance.setTemplateFiles(templateFiles);
        return this.findByExample(instance);
    }

    @Override
    public List<ReportTemplate> findByContextClassId(String contextClassId) {
        ReportTemplate instance = new ReportTemplate();
        instance.setContextClassId(contextClassId);
        return this.findByExample(instance);
    }
}

