/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.dem.managers.impl.model.dao.auto.impl;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.dao.auto.IAutoServerMessageDAO;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage;
import pt.digitalis.dif.model.dataset.HibernateDataSet;
import pt.digitalis.dif.model.dataset.IDataSet;
import pt.digitalis.dif.model.hibernate.IHibernateDAO;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.log.ILogWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutoServerMessageDAOImpl
implements IAutoServerMessageDAO {
    protected ILogWrapper logger = DIFLogger.getLogger();

    @Override
    public IDataSet<ServerMessage> getServerMessageDataSet() {
        return new HibernateDataSet(ServerMessage.class, (IHibernateDAO)this, ServerMessage.getPKFieldListAsString());
    }

    public Session getSession() {
        return DIFRepositoryFactory.getSession();
    }

    @Override
    public void persist(ServerMessage transientInstance) {
        this.logger.debug((Object)"persisting ServerMessage instance");
        this.getSession().persist((Object)transientInstance);
        this.logger.debug((Object)"persist successful");
    }

    @Override
    public void attachDirty(ServerMessage instance) {
        this.logger.debug((Object)"attaching dirty ServerMessage instance");
        this.getSession().saveOrUpdate((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void attachClean(ServerMessage instance) {
        this.logger.debug((Object)"attaching clean ServerMessage instance");
        this.getSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
        this.logger.debug((Object)"attach successful");
    }

    @Override
    public void delete(ServerMessage persistentInstance) {
        this.logger.debug((Object)"deleting ServerMessage instance");
        this.getSession().delete((Object)persistentInstance);
        this.logger.debug((Object)"delete successful");
    }

    @Override
    public ServerMessage merge(ServerMessage detachedInstance) {
        this.logger.debug((Object)"merging ServerMessage instance");
        ServerMessage result = (ServerMessage)this.getSession().merge((Object)detachedInstance);
        this.logger.debug((Object)"merge successful");
        return result;
    }

    @Override
    public ServerMessage findById(Long id) {
        this.logger.debug((Object)("getting ServerMessage instance with id: " + id));
        ServerMessage instance = (ServerMessage)this.getSession().get(ServerMessage.class, (Serializable)id);
        if (instance == null) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instance found");
        }
        return instance;
    }

    @Override
    public List<ServerMessage> findAll() {
        List<ServerMessage> instances = new ArrayList();
        this.logger.debug((Object)"getting all ServerMessage instances");
        instances = this.getSession().createCriteria(ServerMessage.class).list();
        if (instances.size() > 0) {
            this.logger.debug((Object)"get successful, no instance found");
        } else {
            this.logger.debug((Object)"get successful, instances found");
        }
        return instances;
    }

    protected List<ServerMessage> findByExample(ServerMessage instance) {
        this.logger.debug((Object)"finding ServerMessage instance by example");
        List results = this.getSession().createCriteria(ServerMessage.class).add((Criterion)Example.create((Object)instance)).list();
        this.logger.debug((Object)("find by example successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ServerMessage> findByFieldParcial(ServerMessage.Fields field, String value) {
        this.logger.debug((Object)("finding ServerMessage instance by parcial value: " + field + " like " + value));
        List results = this.getSession().createCriteria(ServerMessage.class).add((Criterion)Restrictions.like((String)field.toString(), (String)value, (MatchMode)MatchMode.ANYWHERE).ignoreCase()).list();
        this.logger.debug((Object)("find by parcial value successful, result size: " + results.size()));
        return results;
    }

    @Override
    public List<ServerMessage> findByMessage(String message) {
        ServerMessage instance = new ServerMessage();
        instance.setMessage(message);
        return this.findByExample(instance);
    }

    @Override
    public List<ServerMessage> findByWhen(Timestamp when) {
        ServerMessage instance = new ServerMessage();
        instance.setWhen(when);
        return this.findByExample(instance);
    }

    @Override
    public List<ServerMessage> findByAnswer(String answer) {
        ServerMessage instance = new ServerMessage();
        instance.setAnswer(answer);
        return this.findByExample(instance);
    }

    @Override
    public List<ServerMessage> findByProcessed(boolean processed) {
        ServerMessage instance = new ServerMessage();
        instance.setProcessed(processed);
        return this.findByExample(instance);
    }

    @Override
    public List<ServerMessage> findBySuccess(boolean success) {
        ServerMessage instance = new ServerMessage();
        instance.setSuccess(success);
        return this.findByExample(instance);
    }

    @Override
    public List<ServerMessage> findByElapsedTime(Long elapsedTime) {
        ServerMessage instance = new ServerMessage();
        instance.setElapsedTime(elapsedTime);
        return this.findByExample(instance);
    }
}

