/*
 * Decompiled with CFR 0.152.
 */
package pt.digitalis.dif.servermanager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.digitalis.dif.dem.managers.impl.model.DIFRepositoryFactory;
import pt.digitalis.dif.dem.managers.impl.model.IServersService;
import pt.digitalis.dif.dem.managers.impl.model.data.Server;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerActivityLog;
import pt.digitalis.dif.dem.managers.impl.model.data.ServerMessage;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.model.dataset.DataSetException;
import pt.digitalis.dif.model.dataset.JoinType;
import pt.digitalis.dif.model.utils.AbstractBeanRelationsAttributes;
import pt.digitalis.dif.servermanager.AbstractServerManager;
import pt.digitalis.dif.servermanager.IServerManager;
import pt.digitalis.dif.servermanager.NotifyServersOfNewMessagesToProcess;
import pt.digitalis.dif.servermanager.ServerApplicationNodeInstance;
import pt.digitalis.dif.servermanager.ServerManagerConfigurations;
import pt.digitalis.dif.servermanager.ServerManagerException;
import pt.digitalis.dif.servermanager.ServerMessageDestinationServers;
import pt.digitalis.dif.servermanager.ServerMessageExecutionResult;
import pt.digitalis.dif.servermanager.messages.IServerMessage;
import pt.digitalis.dif.startup.DIFInitializer;
import pt.digitalis.dif.startup.DIFStartupConfiguration;
import pt.digitalis.dif.utils.logging.DIFLogger;
import pt.digitalis.utils.common.IBeanAttributes;
import pt.digitalis.utils.common.StringUtils;
import pt.digitalis.utils.config.AbstractConfigurationsImpl;
import pt.digitalis.utils.config.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManagerDBImpl
extends AbstractServerManager
implements IServerManager {
    private IServersService db;
    private List<ServerApplicationNodeInstance> serversList = new ArrayList<ServerApplicationNodeInstance>();
    private Map<Long, ServerApplicationNodeInstance> serversMapByServerID = new HashMap<Long, ServerApplicationNodeInstance>();

    public boolean allowServerCommunication() {
        return true;
    }

    public void applyNameChange() throws ServerManagerException {
        if (DIFStartupConfiguration.hasMachineIDNameChangePending()) {
            String oldID = DIFStartupConfiguration.getMachineIDForConfigurations() + "|" + AbstractConfigurationsImpl.generalConfigurationPrefix;
            String newID = DIFStartupConfiguration.getNewMachineIDForConfigurationsToApply() + "|" + AbstractConfigurationsImpl.generalConfigurationPrefix;
            boolean wasActive = DIFRepositoryFactory.openTransaction();
            StringBuffer hqlBuffer = new StringBuffer();
            hqlBuffer.append("update " + Server.class.getSimpleName());
            hqlBuffer.append("   set machineServerUid = '" + newID + "'");
            hqlBuffer.append(" where machineServerUid = '" + oldID + "'");
            hqlBuffer.append("   and ipAddress = '" + this.getServerNode().getServerIP() + "'");
            hqlBuffer.append("   and port = '" + this.getServerNode().getPort() + "'");
            DIFRepositoryFactory.getSession().createQuery(hqlBuffer.toString()).executeUpdate();
            if (wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().commit();
            }
            DIFLogger.getLogger().info((Object)("Server serverUID changed to \"" + newID + "\" in control database..."));
        }
    }

    public synchronized void discoverServers() throws ServerManagerException {
        try {
            DIFLogger.getLogger().debug((Object)"Refreshing servers list from control database...");
            ArrayList<ServerApplicationNodeInstance> results = new ArrayList<ServerApplicationNodeInstance>();
            HashMap<Long, ServerApplicationNodeInstance> indexedResults = new HashMap<Long, ServerApplicationNodeInstance>();
            Server currentServerRecord = (Server)this.getServerNode().getServerManagementObject();
            for (Server server : this.getDBService().getServerDataSet().query().equals("active", "true").asList()) {
                if (currentServerRecord != null && server.getId().equals(currentServerRecord.getId())) continue;
                Long currentTime = System.currentTimeMillis();
                Long minutesElapsed = (currentTime - server.getLastSync().getTime()) / 1000L / 60L;
                if (minutesElapsed > ServerManagerConfigurations.getInstance().getPurgeInactiveServerAfterMinutes()) {
                    server.setMissing(true);
                    server.setActive(false);
                    server = (Server)this.getDBService().getServerDataSet().update((IBeanAttributes)server);
                    DIFLogger.getLogger().info((Object)("Server: " + server.getName() + " was marked as INACTIVE after " + minutesElapsed + " minutes of inactivity..."));
                    continue;
                }
                if (minutesElapsed > 10L && !server.isMissing()) {
                    server.setMissing(true);
                    server = (Server)this.getDBService().getServerDataSet().update((IBeanAttributes)server);
                    DIFLogger.getLogger().info((Object)("Server: " + server.getName() + " was marked as MISSING " + minutesElapsed + " minutes of inactivity..."));
                }
                ServerApplicationNodeInstance tmpServerNode = new ServerApplicationNodeInstance(server.getMachineServerUid(), server.getIpAddress(), server.getContextRoot(), server.getPort(), server.getEndpointBaseUrl());
                tmpServerNode.setServerManagementObject((Object)server);
                results.add(tmpServerNode);
                indexedResults.put(server.getId(), tmpServerNode);
                DIFLogger.getLogger().debug((Object)("Server added to ServerSync nodes " + server.getName() + " [" + server.getId() + "]..."));
            }
            this.serversList = results;
            this.serversMapByServerID = indexedResults;
        }
        catch (DataSetException e) {
            throw new ServerManagerException((Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new ServerManagerException((Exception)((Object)e));
        }
    }

    public List<ServerApplicationNodeInstance> getAllServers() throws ServerManagerException {
        return this.serversList;
    }

    private IServersService getDBService() {
        if (this.db == null) {
            this.db = (IServersService)DIFIoCRegistry.getRegistry().getImplementation(IServersService.class);
        }
        return this.db;
    }

    private ServerApplicationNodeInstance getServerApplicationNodeInstanceByServerID(Long id) {
        return this.serversMapByServerID.get(id);
    }

    void internalInitialize() throws ServerManagerException {
    }

    public boolean isValidServerIPAddress(String callerIP) {
        if (StringUtils.isNotBlank((String)callerIP)) {
            for (ServerApplicationNodeInstance server : this.serversList) {
                if (!callerIP.equals(server.getServerIP())) continue;
                DIFLogger.getLogger().debug((Object)("Caller valid: Server " + server.getServerBaseURL() + " is registered for the caller IP " + callerIP));
                return true;
            }
        }
        DIFLogger.getLogger().debug((Object)("Caller INVALID: No server registeres for the caller IP " + callerIP));
        return false;
    }

    public synchronized void keepServerAlive() throws ServerManagerException {
        Server serverRecord = (Server)this.getServerNode().getServerManagementObject();
        if (serverRecord == null) {
            this.registerServer();
            serverRecord = (Server)this.getServerNode().getServerManagementObject();
        }
        if (serverRecord != null) {
            DIFLogger.getLogger().debug((Object)"Performing keep alive for the current server...");
            try {
                serverRecord.setLastSync(new Timestamp(new Date().getTime()));
                serverRecord.setActive(true);
                serverRecord.setMissing(false);
                serverRecord.setLastSync(new Timestamp(new Date().getTime()));
                serverRecord = (Server)this.getDBService().getServerDataSet().update((IBeanAttributes)serverRecord);
            }
            catch (DataSetException e) {
                throw new ServerManagerException((Exception)((Object)e));
            }
        }
    }

    protected synchronized void migrateMessagesBetweenServerEntries(ServerApplicationNodeInstance previousServerNode, ServerApplicationNodeInstance newServerNode, boolean onlyPendingMessages) {
        Server oldServer = (Server)previousServerNode.getServerManagementObject();
        Server newServer = (Server)newServerNode.getServerManagementObject();
        if (oldServer != null && newServer != null && !oldServer.getId().equals(newServer.getId())) {
            String oldServerID = oldServer.getId().toString();
            String newServerID = newServer.getId().toString();
            boolean wasActive = DIFRepositoryFactory.openTransaction();
            StringBuffer hqlBuffer = new StringBuffer();
            hqlBuffer.append("update " + ServerMessage.class.getSimpleName());
            hqlBuffer.append("   set " + (Object)((Object)ServerMessage.FK().serverByServerReceiverId()) + " = " + newServerID);
            hqlBuffer.append(" where " + (Object)((Object)ServerMessage.FK().serverByServerReceiverId()) + " = " + oldServerID);
            if (onlyPendingMessages) {
                hqlBuffer.append("   and processed = false");
            }
            DIFRepositoryFactory.getSession().createQuery(hqlBuffer.toString()).executeUpdate();
            hqlBuffer = new StringBuffer();
            hqlBuffer.append("update " + ServerMessage.class.getSimpleName());
            hqlBuffer.append("   set " + (Object)((Object)ServerMessage.FK().serverByServerSenderId()) + " = " + newServerID);
            hqlBuffer.append(" where " + (Object)((Object)ServerMessage.FK().serverByServerSenderId()) + " = " + oldServerID);
            if (onlyPendingMessages) {
                hqlBuffer.append("   and processed = false");
            }
            DIFRepositoryFactory.getSession().createQuery(hqlBuffer.toString()).executeUpdate();
            if (wasActive) {
                DIFRepositoryFactory.getSession().getTransaction().commit();
            }
            DIFLogger.getLogger().info((Object)("Server messages migrated from server \"" + oldServerID + "\" to " + newServerID + " ('" + newServer.getName() + "') in control database..."));
        }
    }

    public synchronized void processServerMessages() throws ServerManagerException {
        Server serverRecord = (Server)this.getServerNode().getServerManagementObject();
        if (serverRecord != null) {
            DIFLogger.getLogger().debug((Object)"Processing pending server messages");
            try {
                for (ServerMessage message : this.getDBService().getServerMessageDataSet().query().equals(ServerMessage.FK().serverByServerReceiverId().ID(), serverRecord.getId().toString()).equals("processed", "false").addJoin((AbstractBeanRelationsAttributes.AbstractRelations)ServerMessage.FK().serverByServerSenderId(), JoinType.NORMAL).asList()) {
                    Server senderRecord = message.getServerByServerSenderId();
                    ServerApplicationNodeInstance sender = this.getServerApplicationNodeInstanceByServerID(senderRecord.getId());
                    DIFLogger.getLogger().debug((Object)("Processing message from " + senderRecord.getName() + " [" + senderRecord.getId() + "] - Content: " + message.getMessage()));
                    ServerMessageExecutionResult result = this.processServerMessage(message.getMessage(), sender);
                    DIFLogger.getLogger().info((Object)("Processed message from " + senderRecord.getName() + " [" + senderRecord.getId() + "] - " + (result.isSuccess() ? "success!" : "problems ocurred, success = false!")));
                    DIFLogger.getLogger().debug((Object)("Message timestamp: " + message.getWhen().toString()));
                    DIFLogger.getLogger().debug((Object)("Message processed: " + message.getMessage()));
                    DIFLogger.getLogger().debug((Object)("Message result: " + result.toJSONString()));
                    message.setProcessed(true);
                    message.setSuccess(result.isSuccess());
                    message.setAnswer(result.toJSONString());
                    message.setElapsedTime(System.currentTimeMillis() - message.getWhen().getTime());
                    message = (ServerMessage)this.getDBService().getServerMessageDataSet().update((IBeanAttributes)message);
                }
                DIFLogger.getLogger().debug((Object)"Purging old processed messages...");
                boolean wasActive = DIFRepositoryFactory.openTransaction();
                Date olderThan = new Date();
                Calendar c = Calendar.getInstance();
                c.setTime(olderThan);
                c.add(2, -ServerManagerConfigurations.getInstance().getPurgeInactiveServerAfterMinutes().intValue());
                olderThan = c.getTime();
                StringBuffer hqlBuffer = new StringBuffer();
                hqlBuffer.append("delete from " + ServerMessage.class.getSimpleName() + " t");
                hqlBuffer.append(" where " + (Object)((Object)ServerMessage.FK().serverByServerReceiverId()) + " = " + serverRecord.getId());
                hqlBuffer.append("   and t.when = :olderThan");
                int deletedMessages = DIFRepositoryFactory.getSession().createQuery(hqlBuffer.toString()).setTimestamp("olderThan", olderThan).executeUpdate();
                if (wasActive) {
                    DIFRepositoryFactory.getSession().getTransaction().commit();
                }
                if (deletedMessages > 0) {
                    DIFLogger.getLogger().info((Object)("Deleted " + deletedMessages + " messages in the control database (older than " + olderThan + ")..."));
                }
            }
            catch (DataSetException e) {
                throw new ServerManagerException((Exception)((Object)e));
            }
            catch (ConfigurationException e) {
                throw new ServerManagerException((Exception)((Object)e));
            }
            catch (JsonProcessingException e) {
                throw new ServerManagerException((Exception)((Object)e));
            }
        }
    }

    public synchronized void registerServer() throws ServerManagerException {
        Server currentServerRecord = (Server)this.getServerNode().getServerManagementObject();
        try {
            if (StringUtils.isBlank((String)this.getServerNode().getPort())) {
                DIFLogger.getLogger().info((Object)"Server was not registered in control database. Will wait for server port identification...");
            } else if (currentServerRecord == null || !this.getServerNode().getPort().equals(currentServerRecord.getPort())) {
                DIFLogger.getLogger().info((Object)"Registering server in control database...");
                Server serverRecord = (Server)this.getDBService().getServerDataSet().query().equals("ipAddress", this.getServerNode().getServerIP()).equals("port", StringUtils.toStringOrNull((Object)this.getServerNode().getPort())).equals("contextRoot", this.getServerNode().getContextRootID()).singleValue();
                if (serverRecord == null) {
                    serverRecord = new Server();
                    serverRecord.setIpAddress(this.getServerNode().getServerIP());
                    serverRecord.setPort(StringUtils.toStringOrNull((Object)this.getServerNode().getPort()));
                    serverRecord.setContextRoot(this.getServerNode().getContextRootID());
                    serverRecord.setMachineServerUid(DIFStartupConfiguration.hasMachineIDNameChangePending() ? DIFStartupConfiguration.getNewMachineIDForConfigurationsToApply() : DIFStartupConfiguration.getMachineIDForConfigurations());
                    serverRecord.setName(StringUtils.nvl((String)ServerManagerConfigurations.getInstance().getServerCustomName(), (String)(serverRecord.getMachineServerUid() + "|" + serverRecord.getContextRoot())));
                    serverRecord.setEndpointBaseUrl(this.getServerNode().getServerBaseURL());
                    serverRecord.setActive(true);
                    serverRecord.setMissing(false);
                    serverRecord.setBootTime(new Timestamp(DIFInitializer.bootTime.getTime()));
                    serverRecord.setLastSync(new Timestamp(new Date().getTime()));
                    serverRecord = (Server)this.getDBService().getServerDataSet().insert((IBeanAttributes)serverRecord);
                    this.getServerNode().setServerManagementObject((Object)serverRecord);
                    DIFLogger.getLogger().info((Object)"New server registered in control database...");
                } else {
                    ServerActivityLog serverActivityLog = new ServerActivityLog();
                    serverActivityLog.setServer(serverRecord);
                    serverActivityLog.setBootTime(serverRecord.getBootTime());
                    serverActivityLog.setLastSync(serverRecord.getLastSync());
                    serverActivityLog = (ServerActivityLog)this.getDBService().getServerActivityLogDataSet().insert((IBeanAttributes)serverActivityLog);
                    serverRecord.setActive(true);
                    serverRecord.setMissing(false);
                    serverRecord.setBootTime(new Timestamp(DIFInitializer.bootTime.getTime()));
                    serverRecord.setLastSync(new Timestamp(new Date().getTime()));
                    serverRecord.setMachineServerUid(DIFStartupConfiguration.hasMachineIDNameChangePending() ? DIFStartupConfiguration.getNewMachineIDForConfigurationsToApply() : DIFStartupConfiguration.getMachineIDForConfigurations());
                    serverRecord.setName(StringUtils.nvl((String)ServerManagerConfigurations.getInstance().getServerCustomName(), (String)(serverRecord.getMachineServerUid() + "|" + serverRecord.getContextRoot())));
                    serverRecord.setEndpointBaseUrl(this.getServerNode().getServerBaseURL());
                    serverRecord = (Server)this.getDBService().getServerDataSet().update((IBeanAttributes)serverRecord);
                    this.getServerNode().setServerManagementObject((Object)serverRecord);
                    DIFLogger.getLogger().info((Object)"Previous server registered in control database (restart processed in activity log)...");
                }
                this.discoverServers();
            }
        }
        catch (DataSetException e) {
            throw new ServerManagerException((Exception)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new ServerManagerException((Exception)((Object)e));
        }
    }

    public boolean sendMessage(IServerMessage serverMessage) throws ServerManagerException {
        Server serverRecord = (Server)this.getServerNode().getServerManagementObject();
        if (serverRecord == null) {
            DIFLogger.getLogger().warn((Object)("Server message " + serverMessage.getMessageTypeID() + " was not sent since this server is stil not registered!"));
            return false;
        }
        try {
            serverMessage.setSenderServerID(serverRecord.getId());
            ObjectMapper mapper = new ObjectMapper();
            String messageString = mapper.writeValueAsString((Object)serverMessage);
            return this.sendMessageToServers(messageString, serverMessage.getDestinationServersType());
        }
        catch (JsonProcessingException e) {
            throw new ServerManagerException((Exception)((Object)e));
        }
    }

    private boolean sendMessageToServers(String messageString, ServerMessageDestinationServers destinationServersType) throws ServerManagerException {
        List<ServerApplicationNodeInstance> serversToSend;
        Server serverRecord = (Server)this.getServerNode().getServerManagementObject();
        if (serverRecord == null) {
            DIFLogger.getLogger().warn((Object)("Server message " + messageString + " was not sent since this server is stil not registered!"));
            return false;
        }
        switch (destinationServersType) {
            case OTHER_APP_INSTANCES: {
                serversToSend = this.getOtherInstancesOfThisApp();
                break;
            }
            case SAME_SERVER_INSTANCE: {
                serversToSend = this.getAppsRunningOnThisServerInstance();
                break;
            }
            default: {
                serversToSend = this.serversList;
            }
        }
        Timestamp when = new Timestamp(System.currentTimeMillis());
        for (ServerApplicationNodeInstance server : serversToSend) {
            if (server.getServerManagementObject() == null) continue;
            ServerMessage messageRecord = new ServerMessage();
            messageRecord.setServerByServerSenderId(serverRecord);
            messageRecord.setMessage(messageString);
            messageRecord.setWhen(when);
            messageRecord.setProcessed(false);
            messageRecord.setSuccess(false);
            messageRecord.setElapsedTime(0L);
            messageRecord.setServerByServerReceiverId((Server)server.getServerManagementObject());
            try {
                this.getDBService().getServerMessageDataSet().insert((IBeanAttributes)messageRecord);
            }
            catch (DataSetException e) {
                throw new ServerManagerException((Exception)((Object)e));
            }
        }
        new NotifyServersOfNewMessagesToProcess(serversToSend).start();
        return true;
    }
}

